/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription;

public class DescribeProjectVersionsPublisher
implements SdkPublisher<DescribeProjectVersionsResponse> {
    private final RekognitionAsyncClient client;
    private final DescribeProjectVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeProjectVersionsPublisher(RekognitionAsyncClient client, DescribeProjectVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeProjectVersionsPublisher(RekognitionAsyncClient client, DescribeProjectVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeProjectVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeProjectVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProjectVersionDescription> projectVersionDescriptions() {
        Function<DescribeProjectVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projectVersionDescriptions() != null) {
                return response.projectVersionDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeProjectVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeProjectVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeProjectVersionsResponse> {
        private DescribeProjectVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProjectVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeProjectVersionsResponse> nextPage(DescribeProjectVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProjectVersionsPublisher.this.client.describeProjectVersions(DescribeProjectVersionsPublisher.this.firstRequest);
            }
            return DescribeProjectVersionsPublisher.this.client.describeProjectVersions((DescribeProjectVersionsRequest)((Object)DescribeProjectVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

