/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration;

public class ListSnapshotCopyConfigurationsIterable
implements SdkIterable<ListSnapshotCopyConfigurationsResponse> {
    private final RedshiftServerlessClient client;
    private final ListSnapshotCopyConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSnapshotCopyConfigurationsIterable(RedshiftServerlessClient client, ListSnapshotCopyConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSnapshotCopyConfigurationsResponseFetcher();
    }

    public Iterator<ListSnapshotCopyConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotCopyConfiguration> snapshotCopyConfigurations() {
        Function<ListSnapshotCopyConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotCopyConfigurations() != null) {
                return response.snapshotCopyConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSnapshotCopyConfigurationsResponseFetcher
    implements SyncPageFetcher<ListSnapshotCopyConfigurationsResponse> {
        private ListSnapshotCopyConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotCopyConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSnapshotCopyConfigurationsResponse nextPage(ListSnapshotCopyConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotCopyConfigurationsIterable.this.client.listSnapshotCopyConfigurations(ListSnapshotCopyConfigurationsIterable.this.firstRequest);
            }
            return ListSnapshotCopyConfigurationsIterable.this.client.listSnapshotCopyConfigurations((ListSnapshotCopyConfigurationsRequest)((Object)ListSnapshotCopyConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

