/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.OfferingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationOffering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currencyCode").getter(ReservationOffering.getter(ReservationOffering::currencyCode)).setter(ReservationOffering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("duration").getter(ReservationOffering.getter(ReservationOffering::duration)).setter(ReservationOffering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<Double> HOURLY_CHARGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("hourlyCharge").getter(ReservationOffering.getter(ReservationOffering::hourlyCharge)).setter(ReservationOffering.setter(Builder::hourlyCharge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hourlyCharge").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offeringId").getter(ReservationOffering.getter(ReservationOffering::offeringId)).setter(ReservationOffering.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offeringType").getter(ReservationOffering.getter(ReservationOffering::offeringTypeAsString)).setter(ReservationOffering.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()}).build();
    private static final SdkField<Double> UPFRONT_CHARGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("upfrontCharge").getter(ReservationOffering.getter(ReservationOffering::upfrontCharge)).setter(ReservationOffering.setter(Builder::upfrontCharge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontCharge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, DURATION_FIELD, HOURLY_CHARGE_FIELD, OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, UPFRONT_CHARGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservationOffering.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final Integer duration;
    private final Double hourlyCharge;
    private final String offeringId;
    private final String offeringType;
    private final Double upfrontCharge;

    private ReservationOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hourlyCharge = builder.hourlyCharge;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.upfrontCharge = builder.upfrontCharge;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double hourlyCharge() {
        return this.hourlyCharge;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final OfferingType offeringType() {
        return OfferingType.fromValue(this.offeringType);
    }

    public final String offeringTypeAsString() {
        return this.offeringType;
    }

    public final Double upfrontCharge() {
        return this.upfrontCharge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyCharge());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontCharge());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationOffering)) {
            return false;
        }
        ReservationOffering other = (ReservationOffering)obj;
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.hourlyCharge(), other.hourlyCharge()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && Objects.equals(this.upfrontCharge(), other.upfrontCharge());
    }

    public final String toString() {
        return ToString.builder((String)"ReservationOffering").add("CurrencyCode", (Object)this.currencyCode()).add("Duration", (Object)this.duration()).add("HourlyCharge", (Object)this.hourlyCharge()).add("OfferingId", (Object)this.offeringId()).add("OfferingType", (Object)this.offeringTypeAsString()).add("UpfrontCharge", (Object)this.upfrontCharge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "hourlyCharge": {
                return Optional.ofNullable(clazz.cast(this.hourlyCharge()));
            }
            case "offeringId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "offeringType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
            case "upfrontCharge": {
                return Optional.ofNullable(clazz.cast(this.upfrontCharge()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("duration", DURATION_FIELD);
        map.put("hourlyCharge", HOURLY_CHARGE_FIELD);
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("offeringType", OFFERING_TYPE_FIELD);
        map.put("upfrontCharge", UPFRONT_CHARGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationOffering, T> g) {
        return obj -> g.apply((ReservationOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Integer duration;
        private Double hourlyCharge;
        private String offeringId;
        private String offeringType;
        private Double upfrontCharge;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationOffering model) {
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.hourlyCharge(model.hourlyCharge);
            this.offeringId(model.offeringId);
            this.offeringType(model.offeringType);
            this.upfrontCharge(model.upfrontCharge);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getHourlyCharge() {
            return this.hourlyCharge;
        }

        public final void setHourlyCharge(Double hourlyCharge) {
            this.hourlyCharge = hourlyCharge;
        }

        @Override
        public final Builder hourlyCharge(Double hourlyCharge) {
            this.hourlyCharge = hourlyCharge;
            return this;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final Double getUpfrontCharge() {
            return this.upfrontCharge;
        }

        public final void setUpfrontCharge(Double upfrontCharge) {
            this.upfrontCharge = upfrontCharge;
        }

        @Override
        public final Builder upfrontCharge(Double upfrontCharge) {
            this.upfrontCharge = upfrontCharge;
            return this;
        }

        public ReservationOffering build() {
            return new ReservationOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationOffering> {
        public Builder currencyCode(String var1);

        public Builder duration(Integer var1);

        public Builder hourlyCharge(Double var1);

        public Builder offeringId(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingType var1);

        public Builder upfrontCharge(Double var1);
    }
}

