/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.Workgroup;

public class ListWorkgroupsIterable
implements SdkIterable<ListWorkgroupsResponse> {
    private final RedshiftServerlessClient client;
    private final ListWorkgroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkgroupsIterable(RedshiftServerlessClient client, ListWorkgroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkgroupsResponseFetcher();
    }

    public Iterator<ListWorkgroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Workgroup> workgroups() {
        Function<ListWorkgroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workgroups() != null) {
                return response.workgroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkgroupsResponseFetcher
    implements SyncPageFetcher<ListWorkgroupsResponse> {
        private ListWorkgroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkgroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkgroupsResponse nextPage(ListWorkgroupsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkgroupsIterable.this.client.listWorkgroups(ListWorkgroupsIterable.this.firstRequest);
            }
            return ListWorkgroupsIterable.this.client.listWorkgroups((ListWorkgroupsRequest)((Object)ListWorkgroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

