/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint;

public class ListRecoveryPointsPublisher
implements SdkPublisher<ListRecoveryPointsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListRecoveryPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecoveryPointsPublisher(RedshiftServerlessAsyncClient client, ListRecoveryPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecoveryPointsPublisher(RedshiftServerlessAsyncClient client, ListRecoveryPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecoveryPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecoveryPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecoveryPoint> recoveryPoints() {
        Function<ListRecoveryPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryPoints() != null) {
                return response.recoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecoveryPointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecoveryPointsResponseFetcher
    implements AsyncPageFetcher<ListRecoveryPointsResponse> {
        private ListRecoveryPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecoveryPointsResponse> nextPage(ListRecoveryPointsResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsPublisher.this.client.listRecoveryPoints(ListRecoveryPointsPublisher.this.firstRequest);
            }
            return ListRecoveryPointsPublisher.this.client.listRecoveryPoints((ListRecoveryPointsRequest)((Object)ListRecoveryPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

