/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotCopyConfigurationRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, CreateSnapshotCopyConfigurationRequest> {
    private static final SdkField<String> DESTINATION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationKmsKeyId").getter(CreateSnapshotCopyConfigurationRequest.getter(CreateSnapshotCopyConfigurationRequest::destinationKmsKeyId)).setter(CreateSnapshotCopyConfigurationRequest.setter(Builder::destinationKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationKmsKeyId").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationRegion").getter(CreateSnapshotCopyConfigurationRequest.getter(CreateSnapshotCopyConfigurationRequest::destinationRegion)).setter(CreateSnapshotCopyConfigurationRequest.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(CreateSnapshotCopyConfigurationRequest.getter(CreateSnapshotCopyConfigurationRequest::namespaceName)).setter(CreateSnapshotCopyConfigurationRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("snapshotRetentionPeriod").getter(CreateSnapshotCopyConfigurationRequest.getter(CreateSnapshotCopyConfigurationRequest::snapshotRetentionPeriod)).setter(CreateSnapshotCopyConfigurationRequest.setter(Builder::snapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_KMS_KEY_ID_FIELD, DESTINATION_REGION_FIELD, NAMESPACE_NAME_FIELD, SNAPSHOT_RETENTION_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSnapshotCopyConfigurationRequest.memberNameToFieldInitializer();
    private final String destinationKmsKeyId;
    private final String destinationRegion;
    private final String namespaceName;
    private final Integer snapshotRetentionPeriod;

    private CreateSnapshotCopyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.destinationKmsKeyId = builder.destinationKmsKeyId;
        this.destinationRegion = builder.destinationRegion;
        this.namespaceName = builder.namespaceName;
        this.snapshotRetentionPeriod = builder.snapshotRetentionPeriod;
    }

    public final String destinationKmsKeyId() {
        return this.destinationKmsKeyId;
    }

    public final String destinationRegion() {
        return this.destinationRegion;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final Integer snapshotRetentionPeriod() {
        return this.snapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotCopyConfigurationRequest)) {
            return false;
        }
        CreateSnapshotCopyConfigurationRequest other = (CreateSnapshotCopyConfigurationRequest)((Object)obj);
        return Objects.equals(this.destinationKmsKeyId(), other.destinationKmsKeyId()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.snapshotRetentionPeriod(), other.snapshotRetentionPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotCopyConfigurationRequest").add("DestinationKmsKeyId", (Object)this.destinationKmsKeyId()).add("DestinationRegion", (Object)this.destinationRegion()).add("NamespaceName", (Object)this.namespaceName()).add("SnapshotRetentionPeriod", (Object)this.snapshotRetentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.destinationKmsKeyId()));
            }
            case "destinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "snapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationKmsKeyId", DESTINATION_KMS_KEY_ID_FIELD);
        map.put("destinationRegion", DESTINATION_REGION_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("snapshotRetentionPeriod", SNAPSHOT_RETENTION_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotCopyConfigurationRequest, T> g) {
        return obj -> g.apply((CreateSnapshotCopyConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String destinationKmsKeyId;
        private String destinationRegion;
        private String namespaceName;
        private Integer snapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotCopyConfigurationRequest model) {
            super(model);
            this.destinationKmsKeyId(model.destinationKmsKeyId);
            this.destinationRegion(model.destinationRegion);
            this.namespaceName(model.namespaceName);
            this.snapshotRetentionPeriod(model.snapshotRetentionPeriod);
        }

        public final String getDestinationKmsKeyId() {
            return this.destinationKmsKeyId;
        }

        public final void setDestinationKmsKeyId(String destinationKmsKeyId) {
            this.destinationKmsKeyId = destinationKmsKeyId;
        }

        @Override
        public final Builder destinationKmsKeyId(String destinationKmsKeyId) {
            this.destinationKmsKeyId = destinationKmsKeyId;
            return this;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Integer getSnapshotRetentionPeriod() {
            return this.snapshotRetentionPeriod;
        }

        public final void setSnapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
        }

        @Override
        public final Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotCopyConfigurationRequest build() {
            return new CreateSnapshotCopyConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotCopyConfigurationRequest> {
        public Builder destinationKmsKeyId(String var1);

        public Builder destinationRegion(String var1);

        public Builder namespaceName(String var1);

        public Builder snapshotRetentionPeriod(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

