/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint;
import software.amazon.awssdk.services.redshiftserverless.model.RecoveryPointListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecoveryPointsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListRecoveryPointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecoveryPointsResponse.getter(ListRecoveryPointsResponse::nextToken)).setter(ListRecoveryPointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RecoveryPoint>> RECOVERY_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recoveryPoints").getter(ListRecoveryPointsResponse.getter(ListRecoveryPointsResponse::recoveryPoints)).setter(ListRecoveryPointsResponse.setter(Builder::recoveryPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecoveryPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOVERY_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecoveryPointsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RecoveryPoint> recoveryPoints;

    private ListRecoveryPointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recoveryPoints = builder.recoveryPoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecoveryPoints() {
        return this.recoveryPoints != null && !(this.recoveryPoints instanceof SdkAutoConstructList);
    }

    public final List<RecoveryPoint> recoveryPoints() {
        return this.recoveryPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryPoints() ? this.recoveryPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsResponse)) {
            return false;
        }
        ListRecoveryPointsResponse other = (ListRecoveryPointsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecoveryPoints() == other.hasRecoveryPoints() && Objects.equals(this.recoveryPoints(), other.recoveryPoints());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecoveryPointsResponse").add("NextToken", (Object)this.nextToken()).add("RecoveryPoints", this.hasRecoveryPoints() ? this.recoveryPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "recoveryPoints": {
                return Optional.ofNullable(clazz.cast(this.recoveryPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("recoveryPoints", RECOVERY_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsResponse, T> g) {
        return obj -> g.apply((ListRecoveryPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecoveryPoint> recoveryPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recoveryPoints(model.recoveryPoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecoveryPoint.Builder> getRecoveryPoints() {
            List<RecoveryPoint.Builder> result = RecoveryPointListCopier.copyToBuilder(this.recoveryPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecoveryPoints(Collection<RecoveryPoint.BuilderImpl> recoveryPoints) {
            this.recoveryPoints = RecoveryPointListCopier.copyFromBuilder(recoveryPoints);
        }

        @Override
        public final Builder recoveryPoints(Collection<RecoveryPoint> recoveryPoints) {
            this.recoveryPoints = RecoveryPointListCopier.copy(recoveryPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(RecoveryPoint ... recoveryPoints) {
            this.recoveryPoints(Arrays.asList(recoveryPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(Consumer<RecoveryPoint.Builder> ... recoveryPoints) {
            this.recoveryPoints(Stream.of(recoveryPoints).map(c -> (RecoveryPoint)((RecoveryPoint.Builder)RecoveryPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecoveryPointsResponse build() {
            return new ListRecoveryPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecoveryPointsResponse> {
        public Builder nextToken(String var1);

        public Builder recoveryPoints(Collection<RecoveryPoint> var1);

        public Builder recoveryPoints(RecoveryPoint ... var1);

        public Builder recoveryPoints(Consumer<RecoveryPoint.Builder> ... var1);
    }
}

