/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecoveryPointsRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, ListRecoveryPointsRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListRecoveryPointsRequest.getter(ListRecoveryPointsRequest::endTime)).setter(ListRecoveryPointsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRecoveryPointsRequest.getter(ListRecoveryPointsRequest::maxResults)).setter(ListRecoveryPointsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(ListRecoveryPointsRequest.getter(ListRecoveryPointsRequest::namespaceArn)).setter(ListRecoveryPointsRequest.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(ListRecoveryPointsRequest.getter(ListRecoveryPointsRequest::namespaceName)).setter(ListRecoveryPointsRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecoveryPointsRequest.getter(ListRecoveryPointsRequest::nextToken)).setter(ListRecoveryPointsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListRecoveryPointsRequest.getter(ListRecoveryPointsRequest::startTime)).setter(ListRecoveryPointsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, MAX_RESULTS_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecoveryPointsRequest.memberNameToFieldInitializer();
    private final Instant endTime;
    private final Integer maxResults;
    private final String namespaceArn;
    private final String namespaceName;
    private final String nextToken;
    private final Instant startTime;

    private ListRecoveryPointsRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsRequest)) {
            return false;
        }
        ListRecoveryPointsRequest other = (ListRecoveryPointsRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecoveryPointsRequest").add("EndTime", (Object)this.endTime()).add("MaxResults", (Object)this.maxResults()).add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).add("NextToken", (Object)this.nextToken()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endTime", END_TIME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("namespaceArn", NAMESPACE_ARN_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsRequest, T> g) {
        return obj -> g.apply((ListRecoveryPointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private Integer maxResults;
        private String namespaceArn;
        private String namespaceName;
        private String nextToken;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.maxResults(model.maxResults);
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
            this.nextToken(model.nextToken);
            this.startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecoveryPointsRequest build() {
            return new ListRecoveryPointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecoveryPointsRequest> {
        public Builder endTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);

        public Builder nextToken(String var1);

        public Builder startTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

