/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse;

public class DescribeTableIterable
implements SdkIterable<DescribeTableResponse> {
    private final RedshiftDataClient client;
    private final DescribeTableRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTableIterable(RedshiftDataClient client, DescribeTableRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTableResponseFetcher();
    }

    public Iterator<DescribeTableResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ColumnMetadata> columnList() {
        Function<DescribeTableResponse, Iterator> getIterator = response -> {
            if (response != null && response.columnList() != null) {
                return response.columnList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTableResponseFetcher
    implements SyncPageFetcher<DescribeTableResponse> {
        private DescribeTableResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTableResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTableResponse nextPage(DescribeTableResponse previousPage) {
            if (previousPage == null) {
                return DescribeTableIterable.this.client.describeTable(DescribeTableIterable.this.firstRequest);
            }
            return DescribeTableIterable.this.client.describeTable((DescribeTableRequest)((Object)DescribeTableIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

