/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultV2Request;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultV2Response;
import software.amazon.awssdk.services.redshiftdata.model.QueryRecords;

public class GetStatementResultV2Publisher
implements SdkPublisher<GetStatementResultV2Response> {
    private final RedshiftDataAsyncClient client;
    private final GetStatementResultV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetStatementResultV2Publisher(RedshiftDataAsyncClient client, GetStatementResultV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetStatementResultV2Publisher(RedshiftDataAsyncClient client, GetStatementResultV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetStatementResultV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetStatementResultV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QueryRecords> records() {
        return this.flatMapIterable(response -> response.records());
    }

    private class GetStatementResultV2ResponseFetcher
    implements AsyncPageFetcher<GetStatementResultV2Response> {
        private GetStatementResultV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetStatementResultV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetStatementResultV2Response> nextPage(GetStatementResultV2Response previousPage) {
            if (previousPage == null) {
                return GetStatementResultV2Publisher.this.client.getStatementResultV2(GetStatementResultV2Publisher.this.firstRequest);
            }
            return GetStatementResultV2Publisher.this.client.getStatementResultV2((GetStatementResultV2Request)((Object)GetStatementResultV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

