/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse;

public class DescribeTablePublisher
implements SdkPublisher<DescribeTableResponse> {
    private final RedshiftDataAsyncClient client;
    private final DescribeTableRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTablePublisher(RedshiftDataAsyncClient client, DescribeTableRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTablePublisher(RedshiftDataAsyncClient client, DescribeTableRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTableResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTableResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ColumnMetadata> columnList() {
        return this.flatMapIterable(response -> response.columnList());
    }

    private class DescribeTableResponseFetcher
    implements AsyncPageFetcher<DescribeTableResponse> {
        private DescribeTableResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTableResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTableResponse> nextPage(DescribeTableResponse previousPage) {
            if (previousPage == null) {
                return DescribeTablePublisher.this.client.describeTable(DescribeTablePublisher.this.firstRequest);
            }
            return DescribeTablePublisher.this.client.describeTable((DescribeTableRequest)((Object)DescribeTablePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

