/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataRequest;
import software.amazon.awssdk.services.redshiftdata.model.ResultFormatString;
import software.amazon.awssdk.services.redshiftdata.model.SqlListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchExecuteStatementRequest
extends RedshiftDataRequest
implements ToCopyableBuilder<Builder, BatchExecuteStatementRequest> {
    private static final SdkField<List<String>> SQLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sqls").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sqls)).setter(BatchExecuteStatementRequest.setter(Builder::sqls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sqls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::clusterIdentifier)).setter(BatchExecuteStatementRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::secretArn)).setter(BatchExecuteStatementRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::dbUser)).setter(BatchExecuteStatementRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::database)).setter(BatchExecuteStatementRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithEvent").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::withEvent)).setter(BatchExecuteStatementRequest.setter(Builder::withEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()}).build();
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementName").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::statementName)).setter(BatchExecuteStatementRequest.setter(Builder::statementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkgroupName").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::workgroupName)).setter(BatchExecuteStatementRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::clientToken)).setter(BatchExecuteStatementRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultFormat").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::resultFormatAsString)).setter(BatchExecuteStatementRequest.setter(Builder::resultFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()}).build();
    private static final SdkField<Integer> SESSION_KEEP_ALIVE_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionKeepAliveSeconds").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sessionKeepAliveSeconds)).setter(BatchExecuteStatementRequest.setter(Builder::sessionKeepAliveSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeepAliveSeconds").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sessionId)).setter(BatchExecuteStatementRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQLS_FIELD, CLUSTER_IDENTIFIER_FIELD, SECRET_ARN_FIELD, DB_USER_FIELD, DATABASE_FIELD, WITH_EVENT_FIELD, STATEMENT_NAME_FIELD, WORKGROUP_NAME_FIELD, CLIENT_TOKEN_FIELD, RESULT_FORMAT_FIELD, SESSION_KEEP_ALIVE_SECONDS_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchExecuteStatementRequest.memberNameToFieldInitializer();
    private final List<String> sqls;
    private final String clusterIdentifier;
    private final String secretArn;
    private final String dbUser;
    private final String database;
    private final Boolean withEvent;
    private final String statementName;
    private final String workgroupName;
    private final String clientToken;
    private final String resultFormat;
    private final Integer sessionKeepAliveSeconds;
    private final String sessionId;

    private BatchExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.sqls = builder.sqls;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.secretArn = builder.secretArn;
        this.dbUser = builder.dbUser;
        this.database = builder.database;
        this.withEvent = builder.withEvent;
        this.statementName = builder.statementName;
        this.workgroupName = builder.workgroupName;
        this.clientToken = builder.clientToken;
        this.resultFormat = builder.resultFormat;
        this.sessionKeepAliveSeconds = builder.sessionKeepAliveSeconds;
        this.sessionId = builder.sessionId;
    }

    public final boolean hasSqls() {
        return this.sqls != null && !(this.sqls instanceof SdkAutoConstructList);
    }

    public final List<String> sqls() {
        return this.sqls;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String database() {
        return this.database;
    }

    public final Boolean withEvent() {
        return this.withEvent;
    }

    public final String statementName() {
        return this.statementName;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(this.resultFormat);
    }

    public final String resultFormatAsString() {
        return this.resultFormat;
    }

    public final Integer sessionKeepAliveSeconds() {
        return this.sessionKeepAliveSeconds;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSqls() ? this.sqls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.withEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionKeepAliveSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementRequest)) {
            return false;
        }
        BatchExecuteStatementRequest other = (BatchExecuteStatementRequest)((Object)obj);
        return this.hasSqls() == other.hasSqls() && Objects.equals(this.sqls(), other.sqls()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.withEvent(), other.withEvent()) && Objects.equals(this.statementName(), other.statementName()) && Objects.equals(this.workgroupName(), other.workgroupName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.resultFormatAsString(), other.resultFormatAsString()) && Objects.equals(this.sessionKeepAliveSeconds(), other.sessionKeepAliveSeconds()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchExecuteStatementRequest").add("Sqls", this.hasSqls() ? this.sqls() : null).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SecretArn", (Object)this.secretArn()).add("DbUser", (Object)this.dbUser()).add("Database", (Object)this.database()).add("WithEvent", (Object)this.withEvent()).add("StatementName", (Object)this.statementName()).add("WorkgroupName", (Object)this.workgroupName()).add("ClientToken", (Object)this.clientToken()).add("ResultFormat", (Object)this.resultFormatAsString()).add("SessionKeepAliveSeconds", (Object)this.sessionKeepAliveSeconds()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sqls": {
                return Optional.ofNullable(clazz.cast(this.sqls()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "WithEvent": {
                return Optional.ofNullable(clazz.cast(this.withEvent()));
            }
            case "StatementName": {
                return Optional.ofNullable(clazz.cast(this.statementName()));
            }
            case "WorkgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ResultFormat": {
                return Optional.ofNullable(clazz.cast(this.resultFormatAsString()));
            }
            case "SessionKeepAliveSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionKeepAliveSeconds()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Sqls", SQLS_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("WithEvent", WITH_EVENT_FIELD);
        map.put("StatementName", STATEMENT_NAME_FIELD);
        map.put("WorkgroupName", WORKGROUP_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ResultFormat", RESULT_FORMAT_FIELD);
        map.put("SessionKeepAliveSeconds", SESSION_KEEP_ALIVE_SECONDS_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementRequest, T> g) {
        return obj -> g.apply((BatchExecuteStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataRequest.BuilderImpl
    implements Builder {
        private List<String> sqls = DefaultSdkAutoConstructList.getInstance();
        private String clusterIdentifier;
        private String secretArn;
        private String dbUser;
        private String database;
        private Boolean withEvent;
        private String statementName;
        private String workgroupName;
        private String clientToken;
        private String resultFormat;
        private Integer sessionKeepAliveSeconds;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementRequest model) {
            super(model);
            this.sqls(model.sqls);
            this.clusterIdentifier(model.clusterIdentifier);
            this.secretArn(model.secretArn);
            this.dbUser(model.dbUser);
            this.database(model.database);
            this.withEvent(model.withEvent);
            this.statementName(model.statementName);
            this.workgroupName(model.workgroupName);
            this.clientToken(model.clientToken);
            this.resultFormat(model.resultFormat);
            this.sessionKeepAliveSeconds(model.sessionKeepAliveSeconds);
            this.sessionId(model.sessionId);
        }

        public final Collection<String> getSqls() {
            if (this.sqls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sqls;
        }

        public final void setSqls(Collection<String> sqls) {
            this.sqls = SqlListCopier.copy(sqls);
        }

        @Override
        public final Builder sqls(Collection<String> sqls) {
            this.sqls = SqlListCopier.copy(sqls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqls(String ... sqls) {
            this.sqls(Arrays.asList(sqls));
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final Boolean getWithEvent() {
            return this.withEvent;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public final String getStatementName() {
            return this.statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getResultFormat() {
            return this.resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final Integer getSessionKeepAliveSeconds() {
            return this.sessionKeepAliveSeconds;
        }

        public final void setSessionKeepAliveSeconds(Integer sessionKeepAliveSeconds) {
            this.sessionKeepAliveSeconds = sessionKeepAliveSeconds;
        }

        @Override
        public final Builder sessionKeepAliveSeconds(Integer sessionKeepAliveSeconds) {
            this.sessionKeepAliveSeconds = sessionKeepAliveSeconds;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchExecuteStatementRequest build() {
            return new BatchExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchExecuteStatementRequest> {
        public Builder sqls(Collection<String> var1);

        public Builder sqls(String ... var1);

        public Builder clusterIdentifier(String var1);

        public Builder secretArn(String var1);

        public Builder dbUser(String var1);

        public Builder database(String var1);

        public Builder withEvent(Boolean var1);

        public Builder statementName(String var1);

        public Builder workgroupName(String var1);

        public Builder clientToken(String var1);

        public Builder resultFormat(String var1);

        public Builder resultFormat(ResultFormatString var1);

        public Builder sessionKeepAliveSeconds(Integer var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

