/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftdata.model.StatementStatusString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubStatementData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubStatementData> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SubStatementData.getter(SubStatementData::id)).setter(SubStatementData.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(SubStatementData.getter(SubStatementData::duration)).setter(SubStatementData.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(SubStatementData.getter(SubStatementData::error)).setter(SubStatementData.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SubStatementData.getter(SubStatementData::statusAsString)).setter(SubStatementData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(SubStatementData.getter(SubStatementData::createdAt)).setter(SubStatementData.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(SubStatementData.getter(SubStatementData::updatedAt)).setter(SubStatementData.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(SubStatementData.getter(SubStatementData::queryString)).setter(SubStatementData.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<Long> RESULT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ResultRows").getter(SubStatementData.getter(SubStatementData::resultRows)).setter(SubStatementData.setter(Builder::resultRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRows").build()}).build();
    private static final SdkField<Long> RESULT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ResultSize").getter(SubStatementData.getter(SubStatementData::resultSize)).setter(SubStatementData.setter(Builder::resultSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()}).build();
    private static final SdkField<Long> REDSHIFT_QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RedshiftQueryId").getter(SubStatementData.getter(SubStatementData::redshiftQueryId)).setter(SubStatementData.setter(Builder::redshiftQueryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftQueryId").build()}).build();
    private static final SdkField<Boolean> HAS_RESULT_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasResultSet").getter(SubStatementData.getter(SubStatementData::hasResultSet)).setter(SubStatementData.setter(Builder::hasResultSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasResultSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DURATION_FIELD, ERROR_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, QUERY_STRING_FIELD, RESULT_ROWS_FIELD, RESULT_SIZE_FIELD, REDSHIFT_QUERY_ID_FIELD, HAS_RESULT_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubStatementData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Long duration;
    private final String error;
    private final String status;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String queryString;
    private final Long resultRows;
    private final Long resultSize;
    private final Long redshiftQueryId;
    private final Boolean hasResultSet;

    private SubStatementData(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.error = builder.error;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.queryString = builder.queryString;
        this.resultRows = builder.resultRows;
        this.resultSize = builder.resultSize;
        this.redshiftQueryId = builder.redshiftQueryId;
        this.hasResultSet = builder.hasResultSet;
    }

    public final String id() {
        return this.id;
    }

    public final Long duration() {
        return this.duration;
    }

    public final String error() {
        return this.error;
    }

    public final StatementStatusString status() {
        return StatementStatusString.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Long resultRows() {
        return this.resultRows;
    }

    public final Long resultSize() {
        return this.resultSize;
    }

    public final Long redshiftQueryId() {
        return this.redshiftQueryId;
    }

    public final Boolean hasResultSet() {
        return this.hasResultSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultSet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubStatementData)) {
            return false;
        }
        SubStatementData other = (SubStatementData)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.resultRows(), other.resultRows()) && Objects.equals(this.resultSize(), other.resultSize()) && Objects.equals(this.redshiftQueryId(), other.redshiftQueryId()) && Objects.equals(this.hasResultSet(), other.hasResultSet());
    }

    public final String toString() {
        return ToString.builder((String)"SubStatementData").add("Id", (Object)this.id()).add("Duration", (Object)this.duration()).add("Error", (Object)this.error()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("QueryString", (Object)this.queryString()).add("ResultRows", (Object)this.resultRows()).add("ResultSize", (Object)this.resultSize()).add("RedshiftQueryId", (Object)this.redshiftQueryId()).add("HasResultSet", (Object)this.hasResultSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ResultRows": {
                return Optional.ofNullable(clazz.cast(this.resultRows()));
            }
            case "ResultSize": {
                return Optional.ofNullable(clazz.cast(this.resultSize()));
            }
            case "RedshiftQueryId": {
                return Optional.ofNullable(clazz.cast(this.redshiftQueryId()));
            }
            case "HasResultSet": {
                return Optional.ofNullable(clazz.cast(this.hasResultSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("ResultRows", RESULT_ROWS_FIELD);
        map.put("ResultSize", RESULT_SIZE_FIELD);
        map.put("RedshiftQueryId", REDSHIFT_QUERY_ID_FIELD);
        map.put("HasResultSet", HAS_RESULT_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubStatementData, T> g) {
        return obj -> g.apply((SubStatementData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Long duration;
        private String error;
        private String status;
        private Instant createdAt;
        private Instant updatedAt;
        private String queryString;
        private Long resultRows;
        private Long resultSize;
        private Long redshiftQueryId;
        private Boolean hasResultSet;

        private BuilderImpl() {
        }

        private BuilderImpl(SubStatementData model) {
            this.id(model.id);
            this.duration(model.duration);
            this.error(model.error);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.queryString(model.queryString);
            this.resultRows(model.resultRows);
            this.resultSize(model.resultSize);
            this.redshiftQueryId(model.redshiftQueryId);
            this.hasResultSet(model.hasResultSet);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatementStatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Long getResultRows() {
            return this.resultRows;
        }

        public final void setResultRows(Long resultRows) {
            this.resultRows = resultRows;
        }

        @Override
        public final Builder resultRows(Long resultRows) {
            this.resultRows = resultRows;
            return this;
        }

        public final Long getResultSize() {
            return this.resultSize;
        }

        public final void setResultSize(Long resultSize) {
            this.resultSize = resultSize;
        }

        @Override
        public final Builder resultSize(Long resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final Long getRedshiftQueryId() {
            return this.redshiftQueryId;
        }

        public final void setRedshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
        }

        @Override
        public final Builder redshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
            return this;
        }

        public final Boolean getHasResultSet() {
            return this.hasResultSet;
        }

        public final void setHasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
        }

        @Override
        public final Builder hasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
            return this;
        }

        public SubStatementData build() {
            return new SubStatementData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubStatementData> {
        public Builder id(String var1);

        public Builder duration(Long var1);

        public Builder error(String var1);

        public Builder status(String var1);

        public Builder status(StatementStatusString var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder queryString(String var1);

        public Builder resultRows(Long var1);

        public Builder resultSize(Long var1);

        public Builder redshiftQueryId(Long var1);

        public Builder hasResultSet(Boolean var1);
    }
}

