/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.services.redshiftdata.model.StatementData;
import software.amazon.awssdk.services.redshiftdata.model.StatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStatementsResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, ListStatementsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStatementsResponse.getter(ListStatementsResponse::nextToken)).setter(ListStatementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<StatementData>> STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statements").getter(ListStatementsResponse.getter(ListStatementsResponse::statements)).setter(ListStatementsResponse.setter(Builder::statements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatementData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STATEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStatementsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<StatementData> statements;

    private ListStatementsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.statements = builder.statements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStatements() {
        return this.statements != null && !(this.statements instanceof SdkAutoConstructList);
    }

    public final List<StatementData> statements() {
        return this.statements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatements() ? this.statements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStatementsResponse)) {
            return false;
        }
        ListStatementsResponse other = (ListStatementsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStatements() == other.hasStatements() && Objects.equals(this.statements(), other.statements());
    }

    public final String toString() {
        return ToString.builder((String)"ListStatementsResponse").add("NextToken", (Object)this.nextToken()).add("Statements", this.hasStatements() ? this.statements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Statements", STATEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStatementsResponse, T> g) {
        return obj -> g.apply((ListStatementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StatementData> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStatementsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.statements(model.statements);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StatementData.Builder> getStatements() {
            List<StatementData.Builder> result = StatementListCopier.copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<StatementData.BuilderImpl> statements) {
            this.statements = StatementListCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<StatementData> statements) {
            this.statements = StatementListCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(StatementData ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<StatementData.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (StatementData)((StatementData.Builder)StatementData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStatementsResponse build() {
            return new ListStatementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStatementsResponse> {
        public Builder nextToken(String var1);

        public Builder statements(Collection<StatementData> var1);

        public Builder statements(StatementData ... var1);

        public Builder statements(Consumer<StatementData.Builder> ... var1);
    }
}

