/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.model.ProvisionedIdentifier;
import software.amazon.awssdk.services.redshift.model.ServerlessIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamespaceIdentifierUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamespaceIdentifierUnion> {
    private static final SdkField<ServerlessIdentifier> SERVERLESS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessIdentifier").getter(NamespaceIdentifierUnion.getter(NamespaceIdentifierUnion::serverlessIdentifier)).setter(NamespaceIdentifierUnion.setter(Builder::serverlessIdentifier)).constructor(ServerlessIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessIdentifier").build()}).build();
    private static final SdkField<ProvisionedIdentifier> PROVISIONED_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedIdentifier").getter(NamespaceIdentifierUnion.getter(NamespaceIdentifierUnion::provisionedIdentifier)).setter(NamespaceIdentifierUnion.setter(Builder::provisionedIdentifier)).constructor(ProvisionedIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_IDENTIFIER_FIELD, PROVISIONED_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NamespaceIdentifierUnion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ServerlessIdentifier serverlessIdentifier;
    private final ProvisionedIdentifier provisionedIdentifier;
    private final Type type;

    private NamespaceIdentifierUnion(BuilderImpl builder) {
        this.serverlessIdentifier = builder.serverlessIdentifier;
        this.provisionedIdentifier = builder.provisionedIdentifier;
        this.type = builder.type;
    }

    public final ServerlessIdentifier serverlessIdentifier() {
        return this.serverlessIdentifier;
    }

    public final ProvisionedIdentifier provisionedIdentifier() {
        return this.provisionedIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceIdentifierUnion)) {
            return false;
        }
        NamespaceIdentifierUnion other = (NamespaceIdentifierUnion)obj;
        return Objects.equals(this.serverlessIdentifier(), other.serverlessIdentifier()) && Objects.equals(this.provisionedIdentifier(), other.provisionedIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"NamespaceIdentifierUnion").add("ServerlessIdentifier", (Object)this.serverlessIdentifier()).add("ProvisionedIdentifier", (Object)this.provisionedIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerlessIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serverlessIdentifier()));
            }
            case "ProvisionedIdentifier": {
                return Optional.ofNullable(clazz.cast(this.provisionedIdentifier()));
            }
        }
        return Optional.empty();
    }

    public static NamespaceIdentifierUnion fromServerlessIdentifier(ServerlessIdentifier serverlessIdentifier) {
        return (NamespaceIdentifierUnion)NamespaceIdentifierUnion.builder().serverlessIdentifier(serverlessIdentifier).build();
    }

    public static NamespaceIdentifierUnion fromServerlessIdentifier(Consumer<ServerlessIdentifier.Builder> serverlessIdentifier) {
        ServerlessIdentifier.Builder builder = ServerlessIdentifier.builder();
        serverlessIdentifier.accept(builder);
        return NamespaceIdentifierUnion.fromServerlessIdentifier((ServerlessIdentifier)builder.build());
    }

    public static NamespaceIdentifierUnion fromProvisionedIdentifier(ProvisionedIdentifier provisionedIdentifier) {
        return (NamespaceIdentifierUnion)NamespaceIdentifierUnion.builder().provisionedIdentifier(provisionedIdentifier).build();
    }

    public static NamespaceIdentifierUnion fromProvisionedIdentifier(Consumer<ProvisionedIdentifier.Builder> provisionedIdentifier) {
        ProvisionedIdentifier.Builder builder = ProvisionedIdentifier.builder();
        provisionedIdentifier.accept(builder);
        return NamespaceIdentifierUnion.fromProvisionedIdentifier((ProvisionedIdentifier)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerlessIdentifier", SERVERLESS_IDENTIFIER_FIELD);
        map.put("ProvisionedIdentifier", PROVISIONED_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamespaceIdentifierUnion, T> g) {
        return obj -> g.apply((NamespaceIdentifierUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SERVERLESS_IDENTIFIER,
        PROVISIONED_IDENTIFIER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ServerlessIdentifier serverlessIdentifier;
        private ProvisionedIdentifier provisionedIdentifier;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceIdentifierUnion model) {
            this.serverlessIdentifier(model.serverlessIdentifier);
            this.provisionedIdentifier(model.provisionedIdentifier);
        }

        public final ServerlessIdentifier.Builder getServerlessIdentifier() {
            return this.serverlessIdentifier != null ? this.serverlessIdentifier.toBuilder() : null;
        }

        public final void setServerlessIdentifier(ServerlessIdentifier.BuilderImpl serverlessIdentifier) {
            ServerlessIdentifier oldValue = this.serverlessIdentifier;
            this.serverlessIdentifier = serverlessIdentifier != null ? serverlessIdentifier.build() : null;
            this.handleUnionValueChange(Type.SERVERLESS_IDENTIFIER, oldValue, this.serverlessIdentifier);
        }

        @Override
        public final Builder serverlessIdentifier(ServerlessIdentifier serverlessIdentifier) {
            ServerlessIdentifier oldValue = this.serverlessIdentifier;
            this.serverlessIdentifier = serverlessIdentifier;
            this.handleUnionValueChange(Type.SERVERLESS_IDENTIFIER, oldValue, this.serverlessIdentifier);
            return this;
        }

        public final ProvisionedIdentifier.Builder getProvisionedIdentifier() {
            return this.provisionedIdentifier != null ? this.provisionedIdentifier.toBuilder() : null;
        }

        public final void setProvisionedIdentifier(ProvisionedIdentifier.BuilderImpl provisionedIdentifier) {
            ProvisionedIdentifier oldValue = this.provisionedIdentifier;
            this.provisionedIdentifier = provisionedIdentifier != null ? provisionedIdentifier.build() : null;
            this.handleUnionValueChange(Type.PROVISIONED_IDENTIFIER, oldValue, this.provisionedIdentifier);
        }

        @Override
        public final Builder provisionedIdentifier(ProvisionedIdentifier provisionedIdentifier) {
            ProvisionedIdentifier oldValue = this.provisionedIdentifier;
            this.provisionedIdentifier = provisionedIdentifier;
            this.handleUnionValueChange(Type.PROVISIONED_IDENTIFIER, oldValue, this.provisionedIdentifier);
            return this;
        }

        public NamespaceIdentifierUnion build() {
            return new NamespaceIdentifierUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamespaceIdentifierUnion> {
        public Builder serverlessIdentifier(ServerlessIdentifier var1);

        default public Builder serverlessIdentifier(Consumer<ServerlessIdentifier.Builder> serverlessIdentifier) {
            return this.serverlessIdentifier((ServerlessIdentifier)((ServerlessIdentifier.Builder)ServerlessIdentifier.builder().applyMutation(serverlessIdentifier)).build());
        }

        public Builder provisionedIdentifier(ProvisionedIdentifier var1);

        default public Builder provisionedIdentifier(Consumer<ProvisionedIdentifier.Builder> provisionedIdentifier) {
            return this.provisionedIdentifier((ProvisionedIdentifier)((ProvisionedIdentifier.Builder)ProvisionedIdentifier.builder().applyMutation(provisionedIdentifier)).build());
        }
    }
}

