/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;

public class DescribeOrderableClusterOptionsIterable
implements SdkIterable<DescribeOrderableClusterOptionsResponse> {
    private final RedshiftClient client;
    private final DescribeOrderableClusterOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrderableClusterOptionsIterable(RedshiftClient client, DescribeOrderableClusterOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOrderableClusterOptionsResponseFetcher();
    }

    public Iterator<DescribeOrderableClusterOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrderableClusterOption> orderableClusterOptions() {
        Function<DescribeOrderableClusterOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableClusterOptions() != null) {
                return response.orderableClusterOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOrderableClusterOptionsResponseFetcher
    implements SyncPageFetcher<DescribeOrderableClusterOptionsResponse> {
        private DescribeOrderableClusterOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeOrderableClusterOptionsResponse nextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableClusterOptionsIterable.this.client.describeOrderableClusterOptions(DescribeOrderableClusterOptionsIterable.this.firstRequest);
            }
            return DescribeOrderableClusterOptionsIterable.this.client.describeOrderableClusterOptions((DescribeOrderableClusterOptionsRequest)((Object)DescribeOrderableClusterOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

