/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 Access Grants scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadWriteAccess implements SdkPojo, Serializable, ToCopyableBuilder<ReadWriteAccess.Builder, ReadWriteAccess> {
    private static final SdkField<String> AUTHORIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Authorization").getter(getter(ReadWriteAccess::authorizationAsString))
            .setter(setter(Builder::authorization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authorization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorization;

    private ReadWriteAccess(BuilderImpl builder) {
        this.authorization = builder.authorization;
    }

    /**
     * <p>
     * Determines whether the read/write scope is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorization}
     * will return {@link ServiceAuthorization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationAsString}.
     * </p>
     * 
     * @return Determines whether the read/write scope is enabled or disabled.
     * @see ServiceAuthorization
     */
    public final ServiceAuthorization authorization() {
        return ServiceAuthorization.fromValue(authorization);
    }

    /**
     * <p>
     * Determines whether the read/write scope is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorization}
     * will return {@link ServiceAuthorization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationAsString}.
     * </p>
     * 
     * @return Determines whether the read/write scope is enabled or disabled.
     * @see ServiceAuthorization
     */
    public final String authorizationAsString() {
        return authorization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadWriteAccess)) {
            return false;
        }
        ReadWriteAccess other = (ReadWriteAccess) obj;
        return Objects.equals(authorizationAsString(), other.authorizationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadWriteAccess").add("Authorization", authorizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Authorization":
            return Optional.ofNullable(clazz.cast(authorizationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Authorization", AUTHORIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadWriteAccess, T> g) {
        return obj -> g.apply((ReadWriteAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadWriteAccess> {
        /**
         * <p>
         * Determines whether the read/write scope is enabled or disabled.
         * </p>
         * 
         * @param authorization
         *        Determines whether the read/write scope is enabled or disabled.
         * @see ServiceAuthorization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceAuthorization
         */
        Builder authorization(String authorization);

        /**
         * <p>
         * Determines whether the read/write scope is enabled or disabled.
         * </p>
         * 
         * @param authorization
         *        Determines whether the read/write scope is enabled or disabled.
         * @see ServiceAuthorization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceAuthorization
         */
        Builder authorization(ServiceAuthorization authorization);
    }

    static final class BuilderImpl implements Builder {
        private String authorization;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadWriteAccess model) {
            authorization(model.authorization);
        }

        public final String getAuthorization() {
            return authorization;
        }

        public final void setAuthorization(String authorization) {
            this.authorization = authorization;
        }

        @Override
        public final Builder authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        @Override
        public final Builder authorization(ServiceAuthorization authorization) {
            this.authorization(authorization == null ? null : authorization.toString());
            return this;
        }

        @Override
        public ReadWriteAccess build() {
            return new ReadWriteAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
