/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservedNodeExchangeConfigurationOptionsRequest extends RedshiftRequest
        implements
        ToCopyableBuilder<GetReservedNodeExchangeConfigurationOptionsRequest.Builder, GetReservedNodeExchangeConfigurationOptionsRequest> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(GetReservedNodeExchangeConfigurationOptionsRequest::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier")
            .getter(getter(GetReservedNodeExchangeConfigurationOptionsRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier")
            .getter(getter(GetReservedNodeExchangeConfigurationOptionsRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(GetReservedNodeExchangeConfigurationOptionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetReservedNodeExchangeConfigurationOptionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionType;

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final Integer maxRecords;

    private final String marker;

    private GetReservedNodeExchangeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The action type of the reserved-node configuration. The action type can be an exchange initiated from either a
     * snapshot or a resize.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ReservedNodeExchangeActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the reserved-node configuration. The action type can be an exchange initiated from
     *         either a snapshot or a resize.
     * @see ReservedNodeExchangeActionType
     */
    public final ReservedNodeExchangeActionType actionType() {
        return ReservedNodeExchangeActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The action type of the reserved-node configuration. The action type can be an exchange initiated from either a
     * snapshot or a resize.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ReservedNodeExchangeActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the reserved-node configuration. The action type can be an exchange initiated from
     *         either a snapshot or a resize.
     * @see ReservedNodeExchangeActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The identifier for the cluster that is the source for a reserved-node exchange.
     * </p>
     * 
     * @return The identifier for the cluster that is the source for a reserved-node exchange.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier for the snapshot that is the source for the reserved-node exchange.
     * </p>
     * 
     * @return The identifier for the snapshot that is the source for the reserved-node exchange.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code>
     * request. If this parameter is specified, the response includes only records beyond the marker, up to the value
     * specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by
     * providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return An optional pagination token provided by a previous
     *         <code>GetReservedNodeExchangeConfigurationOptions</code> request. If this parameter is specified, the
     *         response includes only records beyond the marker, up to the value specified by the
     *         <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the
     *         returned marker value in the <code>Marker</code> parameter and retrying the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedNodeExchangeConfigurationOptionsRequest)) {
            return false;
        }
        GetReservedNodeExchangeConfigurationOptionsRequest other = (GetReservedNodeExchangeConfigurationOptionsRequest) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservedNodeExchangeConfigurationOptionsRequest").add("ActionType", actionTypeAsString())
                .add("ClusterIdentifier", clusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("SnapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReservedNodeExchangeConfigurationOptionsRequest, T> g) {
        return obj -> g.apply((GetReservedNodeExchangeConfigurationOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservedNodeExchangeConfigurationOptionsRequest> {
        /**
         * <p>
         * The action type of the reserved-node configuration. The action type can be an exchange initiated from either
         * a snapshot or a resize.
         * </p>
         * 
         * @param actionType
         *        The action type of the reserved-node configuration. The action type can be an exchange initiated from
         *        either a snapshot or a resize.
         * @see ReservedNodeExchangeActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedNodeExchangeActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The action type of the reserved-node configuration. The action type can be an exchange initiated from either
         * a snapshot or a resize.
         * </p>
         * 
         * @param actionType
         *        The action type of the reserved-node configuration. The action type can be an exchange initiated from
         *        either a snapshot or a resize.
         * @see ReservedNodeExchangeActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedNodeExchangeActionType
         */
        Builder actionType(ReservedNodeExchangeActionType actionType);

        /**
         * <p>
         * The identifier for the cluster that is the source for a reserved-node exchange.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier for the cluster that is the source for a reserved-node exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier for the snapshot that is the source for the reserved-node exchange.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier for the snapshot that is the source for the reserved-node exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code>
         * request. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records
         * by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous
         *        <code>GetReservedNodeExchangeConfigurationOptions</code> request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by the
         *        <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the
         *        returned marker value in the <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String actionType;

        private String clusterIdentifier;

        private String snapshotIdentifier;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedNodeExchangeConfigurationOptionsRequest model) {
            super(model);
            actionType(model.actionType);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ReservedNodeExchangeActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservedNodeExchangeConfigurationOptionsRequest build() {
            return new GetReservedNodeExchangeConfigurationOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
