/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EndpointAccessesCopier {
    static List<EndpointAccess> copy(Collection<? extends EndpointAccess> endpointAccessesParam) {
        List<EndpointAccess> list;
        if (endpointAccessesParam == null || endpointAccessesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointAccess> modifiableList = new ArrayList<>(endpointAccessesParam.size());
            endpointAccessesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EndpointAccess> copyFromBuilder(Collection<? extends EndpointAccess.Builder> endpointAccessesParam) {
        List<EndpointAccess> list;
        if (endpointAccessesParam == null || endpointAccessesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointAccess> modifiableList = new ArrayList<>(endpointAccessesParam.size());
            endpointAccessesParam.forEach(entry -> {
                EndpointAccess member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EndpointAccess.Builder> copyToBuilder(Collection<? extends EndpointAccess> endpointAccessesParam) {
        List<EndpointAccess.Builder> list;
        if (endpointAccessesParam == null || endpointAccessesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointAccess.Builder> modifiableList = new ArrayList<>(endpointAccessesParam.size());
            endpointAccessesParam.forEach(entry -> {
                EndpointAccess.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
