/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableLoggingRequest extends RedshiftRequest implements
        ToCopyableBuilder<EnableLoggingRequest.Builder, EnableLoggingRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(EnableLoggingRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(EnableLoggingRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(EnableLoggingRequest::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogDestinationType").getter(getter(EnableLoggingRequest::logDestinationTypeAsString))
            .setter(setter(Builder::logDestinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType").build())
            .build();

    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogExports")
            .getter(getter(EnableLoggingRequest::logExports))
            .setter(setter(Builder::logExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogExports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, LOG_DESTINATION_TYPE_FIELD, LOG_EXPORTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final String bucketName;

    private final String s3KeyPrefix;

    private final String logDestinationType;

    private final List<String> logExports;

    private EnableLoggingRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.logDestinationType = builder.logDestinationType;
        this.logExports = builder.logExports;
    }

    /**
     * <p>
     * The identifier of the cluster on which logging is to be started.
     * </p>
     * <p>
     * Example: <code>examplecluster</code>
     * </p>
     * 
     * @return The identifier of the cluster on which logging is to be started.</p>
     *         <p>
     *         Example: <code>examplecluster</code>
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of an existing S3 bucket where the log files are to be stored.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the same region as the cluster
     * </p>
     * </li>
     * <li>
     * <p>
     * The cluster must have read bucket and put object permissions
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of an existing S3 bucket where the log files are to be stored.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the same region as the cluster
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster must have read bucket and put object permissions
     *         </p>
     *         </li>
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix applied to the log file names.
     * </p>
     * <p>
     * Valid characters are any letter from any language, any whitespace character, any numeric character, and the
     * following characters: underscore (<code>_</code>), period (<code>.</code>), colon (<code>:</code>), slash (
     * <code>/</code>), equal (<code>=</code>), plus (<code>+</code>), backslash (<code>\</code>), hyphen (
     * <code>-</code>), at symbol (<code>@</code>).
     * </p>
     * 
     * @return The prefix applied to the log file names.</p>
     *         <p>
     *         Valid characters are any letter from any language, any whitespace character, any numeric character, and
     *         the following characters: underscore (<code>_</code>), period (<code>.</code>), colon (<code>:</code>),
     *         slash (<code>/</code>), equal (<code>=</code>), plus (<code>+</code>), backslash (<code>\</code>), hyphen
     *         (<code>-</code>), at symbol (<code>@</code>).
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #logDestinationType} will return {@link LogDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #logDestinationTypeAsString}.
     * </p>
     * 
     * @return The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
     * @see LogDestinationType
     */
    public final LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(logDestinationType);
    }

    /**
     * <p>
     * The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #logDestinationType} will return {@link LogDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #logDestinationTypeAsString}.
     * </p>
     * 
     * @return The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
     * @see LogDestinationType
     */
    public final String logDestinationTypeAsString() {
        return logDestinationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogExports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogExports() {
        return logExports != null && !(logExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of exported log types. Possible values are <code>connectionlog</code>,
     * <code>useractivitylog</code>, and <code>userlog</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogExports} method.
     * </p>
     * 
     * @return The collection of exported log types. Possible values are <code>connectionlog</code>,
     *         <code>useractivitylog</code>, and <code>userlog</code>.
     */
    public final List<String> logExports() {
        return logExports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogExports() ? logExports() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableLoggingRequest)) {
            return false;
        }
        EnableLoggingRequest other = (EnableLoggingRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix())
                && Objects.equals(logDestinationTypeAsString(), other.logDestinationTypeAsString())
                && hasLogExports() == other.hasLogExports() && Objects.equals(logExports(), other.logExports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableLoggingRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("BucketName", bucketName()).add("S3KeyPrefix", s3KeyPrefix())
                .add("LogDestinationType", logDestinationTypeAsString()).add("LogExports", hasLogExports() ? logExports() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "LogDestinationType":
            return Optional.ofNullable(clazz.cast(logDestinationTypeAsString()));
        case "LogExports":
            return Optional.ofNullable(clazz.cast(logExports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("S3KeyPrefix", S3_KEY_PREFIX_FIELD);
        map.put("LogDestinationType", LOG_DESTINATION_TYPE_FIELD);
        map.put("LogExports", LOG_EXPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableLoggingRequest, T> g) {
        return obj -> g.apply((EnableLoggingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableLoggingRequest> {
        /**
         * <p>
         * The identifier of the cluster on which logging is to be started.
         * </p>
         * <p>
         * Example: <code>examplecluster</code>
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster on which logging is to be started.</p>
         *        <p>
         *        Example: <code>examplecluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of an existing S3 bucket where the log files are to be stored.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the same region as the cluster
         * </p>
         * </li>
         * <li>
         * <p>
         * The cluster must have read bucket and put object permissions
         * </p>
         * </li>
         * </ul>
         * 
         * @param bucketName
         *        The name of an existing S3 bucket where the log files are to be stored.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the same region as the cluster
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The cluster must have read bucket and put object permissions
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix applied to the log file names.
         * </p>
         * <p>
         * Valid characters are any letter from any language, any whitespace character, any numeric character, and the
         * following characters: underscore (<code>_</code>), period (<code>.</code>), colon (<code>:</code>), slash (
         * <code>/</code>), equal (<code>=</code>), plus (<code>+</code>), backslash (<code>\</code>), hyphen (
         * <code>-</code>), at symbol (<code>@</code>).
         * </p>
         * 
         * @param s3KeyPrefix
         *        The prefix applied to the log file names.</p>
         *        <p>
         *        Valid characters are any letter from any language, any whitespace character, any numeric character,
         *        and the following characters: underscore (<code>_</code>), period (<code>.</code>), colon (
         *        <code>:</code>), slash (<code>/</code>), equal (<code>=</code>), plus (<code>+</code>), backslash (
         *        <code>\</code>), hyphen (<code>-</code>), at symbol (<code>@</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
         * </p>
         * 
         * @param logDestinationType
         *        The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
         * @see LogDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDestinationType
         */
        Builder logDestinationType(String logDestinationType);

        /**
         * <p>
         * The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
         * </p>
         * 
         * @param logDestinationType
         *        The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.
         * @see LogDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDestinationType
         */
        Builder logDestinationType(LogDestinationType logDestinationType);

        /**
         * <p>
         * The collection of exported log types. Possible values are <code>connectionlog</code>,
         * <code>useractivitylog</code>, and <code>userlog</code>.
         * </p>
         * 
         * @param logExports
         *        The collection of exported log types. Possible values are <code>connectionlog</code>,
         *        <code>useractivitylog</code>, and <code>userlog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExports(Collection<String> logExports);

        /**
         * <p>
         * The collection of exported log types. Possible values are <code>connectionlog</code>,
         * <code>useractivitylog</code>, and <code>userlog</code>.
         * </p>
         * 
         * @param logExports
         *        The collection of exported log types. Possible values are <code>connectionlog</code>,
         *        <code>useractivitylog</code>, and <code>userlog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExports(String... logExports);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String bucketName;

        private String s3KeyPrefix;

        private String logDestinationType;

        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableLoggingRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            bucketName(model.bucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            logDestinationType(model.logDestinationType);
            logExports(model.logExports);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final String getLogDestinationType() {
            return logDestinationType;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final Collection<String> getLogExports() {
            if (logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogTypeListCopier.copy(logExports);
        }

        @Override
        public final Builder logExports(Collection<String> logExports) {
            this.logExports = LogTypeListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(String... logExports) {
            logExports(Arrays.asList(logExports));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableLoggingRequest build() {
            return new EnableLoggingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
