/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterNamespaceRequest extends RedshiftRequest implements
        ToCopyableBuilder<DeregisterNamespaceRequest.Builder, DeregisterNamespaceRequest> {
    private static final SdkField<NamespaceIdentifierUnion> NAMESPACE_IDENTIFIER_FIELD = SdkField
            .<NamespaceIdentifierUnion> builder(MarshallingType.SDK_POJO).memberName("NamespaceIdentifier")
            .getter(getter(DeregisterNamespaceRequest::namespaceIdentifier)).setter(setter(Builder::namespaceIdentifier))
            .constructor(NamespaceIdentifierUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceIdentifier").build())
            .build();

    private static final SdkField<List<String>> CONSUMER_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConsumerIdentifiers")
            .getter(getter(DeregisterNamespaceRequest::consumerIdentifiers))
            .setter(setter(Builder::consumerIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_IDENTIFIER_FIELD,
            CONSUMER_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final NamespaceIdentifierUnion namespaceIdentifier;

    private final List<String> consumerIdentifiers;

    private DeregisterNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceIdentifier = builder.namespaceIdentifier;
        this.consumerIdentifiers = builder.consumerIdentifiers;
    }

    /**
     * <p>
     * The unique identifier of the cluster or serverless namespace that you want to deregister.
     * </p>
     * 
     * @return The unique identifier of the cluster or serverless namespace that you want to deregister.
     */
    public final NamespaceIdentifierUnion namespaceIdentifier() {
        return namespaceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumerIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConsumerIdentifiers() {
        return consumerIdentifiers != null && !(consumerIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the ID of the consumer account that you want to deregister the cluster or serverless
     * namespace from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumerIdentifiers} method.
     * </p>
     * 
     * @return An array containing the ID of the consumer account that you want to deregister the cluster or serverless
     *         namespace from.
     */
    public final List<String> consumerIdentifiers() {
        return consumerIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumerIdentifiers() ? consumerIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterNamespaceRequest)) {
            return false;
        }
        DeregisterNamespaceRequest other = (DeregisterNamespaceRequest) obj;
        return Objects.equals(namespaceIdentifier(), other.namespaceIdentifier())
                && hasConsumerIdentifiers() == other.hasConsumerIdentifiers()
                && Objects.equals(consumerIdentifiers(), other.consumerIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterNamespaceRequest").add("NamespaceIdentifier", namespaceIdentifier())
                .add("ConsumerIdentifiers", hasConsumerIdentifiers() ? consumerIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamespaceIdentifier":
            return Optional.ofNullable(clazz.cast(namespaceIdentifier()));
        case "ConsumerIdentifiers":
            return Optional.ofNullable(clazz.cast(consumerIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NamespaceIdentifier", NAMESPACE_IDENTIFIER_FIELD);
        map.put("ConsumerIdentifiers", CONSUMER_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterNamespaceRequest, T> g) {
        return obj -> g.apply((DeregisterNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterNamespaceRequest> {
        /**
         * <p>
         * The unique identifier of the cluster or serverless namespace that you want to deregister.
         * </p>
         * 
         * @param namespaceIdentifier
         *        The unique identifier of the cluster or serverless namespace that you want to deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceIdentifier(NamespaceIdentifierUnion namespaceIdentifier);

        /**
         * <p>
         * The unique identifier of the cluster or serverless namespace that you want to deregister.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamespaceIdentifierUnion.Builder}
         * avoiding the need to create one manually via {@link NamespaceIdentifierUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NamespaceIdentifierUnion.Builder#build()} is called immediately
         * and its result is passed to {@link #namespaceIdentifier(NamespaceIdentifierUnion)}.
         * 
         * @param namespaceIdentifier
         *        a consumer that will call methods on {@link NamespaceIdentifierUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespaceIdentifier(NamespaceIdentifierUnion)
         */
        default Builder namespaceIdentifier(Consumer<NamespaceIdentifierUnion.Builder> namespaceIdentifier) {
            return namespaceIdentifier(NamespaceIdentifierUnion.builder().applyMutation(namespaceIdentifier).build());
        }

        /**
         * <p>
         * An array containing the ID of the consumer account that you want to deregister the cluster or serverless
         * namespace from.
         * </p>
         * 
         * @param consumerIdentifiers
         *        An array containing the ID of the consumer account that you want to deregister the cluster or
         *        serverless namespace from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerIdentifiers(Collection<String> consumerIdentifiers);

        /**
         * <p>
         * An array containing the ID of the consumer account that you want to deregister the cluster or serverless
         * namespace from.
         * </p>
         * 
         * @param consumerIdentifiers
         *        An array containing the ID of the consumer account that you want to deregister the cluster or
         *        serverless namespace from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerIdentifiers(String... consumerIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private NamespaceIdentifierUnion namespaceIdentifier;

        private List<String> consumerIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterNamespaceRequest model) {
            super(model);
            namespaceIdentifier(model.namespaceIdentifier);
            consumerIdentifiers(model.consumerIdentifiers);
        }

        public final NamespaceIdentifierUnion.Builder getNamespaceIdentifier() {
            return namespaceIdentifier != null ? namespaceIdentifier.toBuilder() : null;
        }

        public final void setNamespaceIdentifier(NamespaceIdentifierUnion.BuilderImpl namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier != null ? namespaceIdentifier.build() : null;
        }

        @Override
        public final Builder namespaceIdentifier(NamespaceIdentifierUnion namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier;
            return this;
        }

        public final Collection<String> getConsumerIdentifiers() {
            if (consumerIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return consumerIdentifiers;
        }

        public final void setConsumerIdentifiers(Collection<String> consumerIdentifiers) {
            this.consumerIdentifiers = ConsumerIdentifierListCopier.copy(consumerIdentifiers);
        }

        @Override
        public final Builder consumerIdentifiers(Collection<String> consumerIdentifiers) {
            this.consumerIdentifiers = ConsumerIdentifierListCopier.copy(consumerIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerIdentifiers(String... consumerIdentifiers) {
            consumerIdentifiers(Arrays.asList(consumerIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterNamespaceRequest build() {
            return new DeregisterNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
