/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterSnapshotResponse extends RedshiftResponse implements
        ToCopyableBuilder<CreateClusterSnapshotResponse.Builder, CreateClusterSnapshotResponse> {
    private static final SdkField<Snapshot> SNAPSHOT_FIELD = SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
            .memberName("Snapshot").getter(getter(CreateClusterSnapshotResponse::snapshot)).setter(setter(Builder::snapshot))
            .constructor(Snapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Snapshot snapshot;

    private CreateClusterSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshot = builder.snapshot;
    }

    /**
     * Returns the value of the Snapshot property for this object.
     * 
     * @return The value of the Snapshot property for this object.
     */
    public final Snapshot snapshot() {
        return snapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSnapshotResponse)) {
            return false;
        }
        CreateClusterSnapshotResponse other = (CreateClusterSnapshotResponse) obj;
        return Objects.equals(snapshot(), other.snapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterSnapshotResponse").add("Snapshot", snapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshot":
            return Optional.ofNullable(clazz.cast(snapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Snapshot", SNAPSHOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterSnapshotResponse, T> g) {
        return obj -> g.apply((CreateClusterSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterSnapshotResponse> {
        /**
         * Sets the value of the Snapshot property for this object.
         *
         * @param snapshot
         *        The new value for the Snapshot property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshot(Snapshot snapshot);

        /**
         * Sets the value of the Snapshot property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Snapshot.Builder} avoiding the need to
         * create one manually via {@link Snapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Snapshot.Builder#build()} is called immediately and its result is
         * passed to {@link #snapshot(Snapshot)}.
         * 
         * @param snapshot
         *        a consumer that will call methods on {@link Snapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshot(Snapshot)
         */
        default Builder snapshot(Consumer<Snapshot.Builder> snapshot) {
            return snapshot(Snapshot.builder().applyMutation(snapshot).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private Snapshot snapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterSnapshotResponse model) {
            super(model);
            snapshot(model.snapshot);
        }

        public final Snapshot.Builder getSnapshot() {
            return snapshot != null ? snapshot.toBuilder() : null;
        }

        public final void setSnapshot(Snapshot.BuilderImpl snapshot) {
            this.snapshot = snapshot != null ? snapshot.build() : null;
        }

        @Override
        public final Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @Override
        public CreateClusterSnapshotResponse build() {
            return new CreateClusterSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
