/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterNode> {
    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeRole").getter(ClusterNode.getter(ClusterNode::nodeRole)).setter(ClusterNode.setter(Builder::nodeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRole").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIPAddress").getter(ClusterNode.getter(ClusterNode::privateIPAddress)).setter(ClusterNode.setter(Builder::privateIPAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIPAddress").build()}).build();
    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIPAddress").getter(ClusterNode.getter(ClusterNode::publicIPAddress)).setter(ClusterNode.setter(Builder::publicIPAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIPAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ROLE_FIELD, PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterNode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeRole;
    private final String privateIPAddress;
    private final String publicIPAddress;

    private ClusterNode(BuilderImpl builder) {
        this.nodeRole = builder.nodeRole;
        this.privateIPAddress = builder.privateIPAddress;
        this.publicIPAddress = builder.publicIPAddress;
    }

    public final String nodeRole() {
        return this.nodeRole;
    }

    public final String privateIPAddress() {
        return this.privateIPAddress;
    }

    public final String publicIPAddress() {
        return this.publicIPAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIPAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIPAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode other = (ClusterNode)obj;
        return Objects.equals(this.nodeRole(), other.nodeRole()) && Objects.equals(this.privateIPAddress(), other.privateIPAddress()) && Objects.equals(this.publicIPAddress(), other.publicIPAddress());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterNode").add("NodeRole", (Object)this.nodeRole()).add("PrivateIPAddress", (Object)this.privateIPAddress()).add("PublicIPAddress", (Object)this.publicIPAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeRole": {
                return Optional.ofNullable(clazz.cast(this.nodeRole()));
            }
            case "PrivateIPAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIPAddress()));
            }
            case "PublicIPAddress": {
                return Optional.ofNullable(clazz.cast(this.publicIPAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NodeRole", NODE_ROLE_FIELD);
        map.put("PrivateIPAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("PublicIPAddress", PUBLIC_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterNode, T> g) {
        return obj -> g.apply((ClusterNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeRole;
        private String privateIPAddress;
        private String publicIPAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNode model) {
            this.nodeRole(model.nodeRole);
            this.privateIPAddress(model.privateIPAddress);
            this.publicIPAddress(model.publicIPAddress);
        }

        public final String getNodeRole() {
            return this.nodeRole;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final String getPrivateIPAddress() {
            return this.privateIPAddress;
        }

        public final void setPrivateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
        }

        @Override
        public final Builder privateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
            return this;
        }

        public final String getPublicIPAddress() {
            return this.publicIPAddress;
        }

        public final void setPublicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
        }

        @Override
        public final Builder publicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
            return this;
        }

        public ClusterNode build() {
            return new ClusterNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterNode> {
        public Builder nodeRole(String var1);

        public Builder privateIPAddress(String var1);

        public Builder publicIPAddress(String var1);
    }
}

