/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TypeHint {
    JSON("JSON"),
    UUID("UUID"),
    TIMESTAMP("TIMESTAMP"),
    DATE("DATE"),
    TIME("TIME"),
    DECIMAL("DECIMAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TypeHint> VALUE_MAP;
    private final String value;

    private TypeHint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypeHint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypeHint> knownValues() {
        EnumSet<TypeHint> knownValues = EnumSet.allOf(TypeHint.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TypeHint.class, TypeHint::toString);
    }
}

