/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.Subnet;
import software.amazon.awssdk.services.rds.model.SubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBSubnetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBSubnetGroup> {
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(DBSubnetGroup.getter(DBSubnetGroup::dbSubnetGroupName)).setter(DBSubnetGroup.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupDescription").getter(DBSubnetGroup.getter(DBSubnetGroup::dbSubnetGroupDescription)).setter(DBSubnetGroup.setter(Builder::dbSubnetGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupDescription").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DBSubnetGroup.getter(DBSubnetGroup::vpcId)).setter(DBSubnetGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupStatus").getter(DBSubnetGroup.getter(DBSubnetGroup::subnetGroupStatus)).setter(DBSubnetGroup.setter(Builder::subnetGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()}).build();
    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(DBSubnetGroup.getter(DBSubnetGroup::subnets)).setter(DBSubnetGroup.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName("Subnet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupArn").getter(DBSubnetGroup.getter(DBSubnetGroup::dbSubnetGroupArn)).setter(DBSubnetGroup.setter(Builder::dbSubnetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupArn").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_NETWORK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNetworkTypes").getter(DBSubnetGroup.getter(DBSubnetGroup::supportedNetworkTypes)).setter(DBSubnetGroup.setter(Builder::supportedNetworkTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNetworkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SUBNET_GROUP_NAME_FIELD, DB_SUBNET_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD, DB_SUBNET_GROUP_ARN_FIELD, SUPPORTED_NETWORK_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DBSubnetGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbSubnetGroupName;
    private final String dbSubnetGroupDescription;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;
    private final String dbSubnetGroupArn;
    private final List<String> supportedNetworkTypes;

    private DBSubnetGroup(BuilderImpl builder) {
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.dbSubnetGroupArn = builder.dbSubnetGroupArn;
        this.supportedNetworkTypes = builder.supportedNetworkTypes;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String dbSubnetGroupDescription() {
        return this.dbSubnetGroupDescription;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<Subnet> subnets() {
        return this.subnets;
    }

    public final String dbSubnetGroupArn() {
        return this.dbSubnetGroupArn;
    }

    public final boolean hasSupportedNetworkTypes() {
        return this.supportedNetworkTypes != null && !(this.supportedNetworkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedNetworkTypes() {
        return this.supportedNetworkTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNetworkTypes() ? this.supportedNetworkTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSubnetGroup)) {
            return false;
        }
        DBSubnetGroup other = (DBSubnetGroup)obj;
        return Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.dbSubnetGroupDescription(), other.dbSubnetGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetGroupStatus(), other.subnetGroupStatus()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.dbSubnetGroupArn(), other.dbSubnetGroupArn()) && this.hasSupportedNetworkTypes() == other.hasSupportedNetworkTypes() && Objects.equals(this.supportedNetworkTypes(), other.supportedNetworkTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DBSubnetGroup").add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DBSubnetGroupDescription", (Object)this.dbSubnetGroupDescription()).add("VpcId", (Object)this.vpcId()).add("SubnetGroupStatus", (Object)this.subnetGroupStatus()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("DBSubnetGroupArn", (Object)this.dbSubnetGroupArn()).add("SupportedNetworkTypes", this.hasSupportedNetworkTypes() ? this.supportedNetworkTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DBSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupDescription()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupStatus()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "DBSubnetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupArn()));
            }
            case "SupportedNetworkTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedNetworkTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("DBSubnetGroupDescription", DB_SUBNET_GROUP_DESCRIPTION_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetGroupStatus", SUBNET_GROUP_STATUS_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("DBSubnetGroupArn", DB_SUBNET_GROUP_ARN_FIELD);
        map.put("SupportedNetworkTypes", SUPPORTED_NETWORK_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBSubnetGroup, T> g) {
        return obj -> g.apply((DBSubnetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSubnetGroupName;
        private String dbSubnetGroupDescription;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();
        private String dbSubnetGroupArn;
        private List<String> supportedNetworkTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBSubnetGroup model) {
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.dbSubnetGroupDescription(model.dbSubnetGroupDescription);
            this.vpcId(model.vpcId);
            this.subnetGroupStatus(model.subnetGroupStatus);
            this.subnets(model.subnets);
            this.dbSubnetGroupArn(model.dbSubnetGroupArn);
            this.supportedNetworkTypes(model.supportedNetworkTypes);
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getDbSubnetGroupDescription() {
            return this.dbSubnetGroupDescription;
        }

        public final void setDbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (Subnet)((Subnet.Builder)Subnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbSubnetGroupArn() {
            return this.dbSubnetGroupArn;
        }

        public final void setDbSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
        }

        @Override
        public final Builder dbSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
            return this;
        }

        public final Collection<String> getSupportedNetworkTypes() {
            if (this.supportedNetworkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedNetworkTypes;
        }

        public final void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = StringListCopier.copy(supportedNetworkTypes);
        }

        @Override
        public final Builder supportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = StringListCopier.copy(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypes(String ... supportedNetworkTypes) {
            this.supportedNetworkTypes(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        public DBSubnetGroup build() {
            return new DBSubnetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBSubnetGroup> {
        public Builder dbSubnetGroupName(String var1);

        public Builder dbSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder subnets(Consumer<Subnet.Builder> ... var1);

        public Builder dbSubnetGroupArn(String var1);

        public Builder supportedNetworkTypes(Collection<String> var1);

        public Builder supportedNetworkTypes(String ... var1);
    }
}

