/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.SelfUpgradeAdminAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSelfUpgradeRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateSelfUpgradeRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateSelfUpgradeRequest.getter(UpdateSelfUpgradeRequest::awsAccountId)).setter(UpdateSelfUpgradeRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(UpdateSelfUpgradeRequest.getter(UpdateSelfUpgradeRequest::namespace)).setter(UpdateSelfUpgradeRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final SdkField<String> UPGRADE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeRequestId").getter(UpdateSelfUpgradeRequest.getter(UpdateSelfUpgradeRequest::upgradeRequestId)).setter(UpdateSelfUpgradeRequest.setter(Builder::upgradeRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeRequestId").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(UpdateSelfUpgradeRequest.getter(UpdateSelfUpgradeRequest::actionAsString)).setter(UpdateSelfUpgradeRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, UPGRADE_REQUEST_ID_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSelfUpgradeRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String namespace;
    private final String upgradeRequestId;
    private final String action;

    private UpdateSelfUpgradeRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.upgradeRequestId = builder.upgradeRequestId;
        this.action = builder.action;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String upgradeRequestId() {
        return this.upgradeRequestId;
    }

    public final SelfUpgradeAdminAction action() {
        return SelfUpgradeAdminAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSelfUpgradeRequest)) {
            return false;
        }
        UpdateSelfUpgradeRequest other = (UpdateSelfUpgradeRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.upgradeRequestId(), other.upgradeRequestId()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSelfUpgradeRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).add("UpgradeRequestId", (Object)this.upgradeRequestId()).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "UpgradeRequestId": {
                return Optional.ofNullable(clazz.cast(this.upgradeRequestId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("UpgradeRequestId", UPGRADE_REQUEST_ID_FIELD);
        map.put("Action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSelfUpgradeRequest, T> g) {
        return obj -> g.apply((UpdateSelfUpgradeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String namespace;
        private String upgradeRequestId;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSelfUpgradeRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
            this.upgradeRequestId(model.upgradeRequestId);
            this.action(model.action);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getUpgradeRequestId() {
            return this.upgradeRequestId;
        }

        public final void setUpgradeRequestId(String upgradeRequestId) {
            this.upgradeRequestId = upgradeRequestId;
        }

        @Override
        public final Builder upgradeRequestId(String upgradeRequestId) {
            this.upgradeRequestId = upgradeRequestId;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(SelfUpgradeAdminAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSelfUpgradeRequest build() {
            return new UpdateSelfUpgradeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSelfUpgradeRequest> {
        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder upgradeRequestId(String var1);

        public Builder action(String var1);

        public Builder action(SelfUpgradeAdminAction var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

