/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Font;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.FontListCopier;
import software.amazon.awssdk.services.quicksight.model.VisualSubtitleFontConfiguration;
import software.amazon.awssdk.services.quicksight.model.VisualTitleFontConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Typography
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Typography> {
    private static final SdkField<List<Font>> FONT_FAMILIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FontFamilies").getter(Typography.getter(Typography::fontFamilies)).setter(Typography.setter(Builder::fontFamilies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamilies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Font::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FontConfiguration> AXIS_TITLE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AxisTitleFontConfiguration").getter(Typography.getter(Typography::axisTitleFontConfiguration)).setter(Typography.setter(Builder::axisTitleFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisTitleFontConfiguration").build()}).build();
    private static final SdkField<FontConfiguration> AXIS_LABEL_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AxisLabelFontConfiguration").getter(Typography.getter(Typography::axisLabelFontConfiguration)).setter(Typography.setter(Builder::axisLabelFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisLabelFontConfiguration").build()}).build();
    private static final SdkField<FontConfiguration> LEGEND_TITLE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LegendTitleFontConfiguration").getter(Typography.getter(Typography::legendTitleFontConfiguration)).setter(Typography.setter(Builder::legendTitleFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegendTitleFontConfiguration").build()}).build();
    private static final SdkField<FontConfiguration> LEGEND_VALUE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LegendValueFontConfiguration").getter(Typography.getter(Typography::legendValueFontConfiguration)).setter(Typography.setter(Builder::legendValueFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegendValueFontConfiguration").build()}).build();
    private static final SdkField<FontConfiguration> DATA_LABEL_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLabelFontConfiguration").getter(Typography.getter(Typography::dataLabelFontConfiguration)).setter(Typography.setter(Builder::dataLabelFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabelFontConfiguration").build()}).build();
    private static final SdkField<VisualTitleFontConfiguration> VISUAL_TITLE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualTitleFontConfiguration").getter(Typography.getter(Typography::visualTitleFontConfiguration)).setter(Typography.setter(Builder::visualTitleFontConfiguration)).constructor(VisualTitleFontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualTitleFontConfiguration").build()}).build();
    private static final SdkField<VisualSubtitleFontConfiguration> VISUAL_SUBTITLE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualSubtitleFontConfiguration").getter(Typography.getter(Typography::visualSubtitleFontConfiguration)).setter(Typography.setter(Builder::visualSubtitleFontConfiguration)).constructor(VisualSubtitleFontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualSubtitleFontConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_FAMILIES_FIELD, AXIS_TITLE_FONT_CONFIGURATION_FIELD, AXIS_LABEL_FONT_CONFIGURATION_FIELD, LEGEND_TITLE_FONT_CONFIGURATION_FIELD, LEGEND_VALUE_FONT_CONFIGURATION_FIELD, DATA_LABEL_FONT_CONFIGURATION_FIELD, VISUAL_TITLE_FONT_CONFIGURATION_FIELD, VISUAL_SUBTITLE_FONT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Typography.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Font> fontFamilies;
    private final FontConfiguration axisTitleFontConfiguration;
    private final FontConfiguration axisLabelFontConfiguration;
    private final FontConfiguration legendTitleFontConfiguration;
    private final FontConfiguration legendValueFontConfiguration;
    private final FontConfiguration dataLabelFontConfiguration;
    private final VisualTitleFontConfiguration visualTitleFontConfiguration;
    private final VisualSubtitleFontConfiguration visualSubtitleFontConfiguration;

    private Typography(BuilderImpl builder) {
        this.fontFamilies = builder.fontFamilies;
        this.axisTitleFontConfiguration = builder.axisTitleFontConfiguration;
        this.axisLabelFontConfiguration = builder.axisLabelFontConfiguration;
        this.legendTitleFontConfiguration = builder.legendTitleFontConfiguration;
        this.legendValueFontConfiguration = builder.legendValueFontConfiguration;
        this.dataLabelFontConfiguration = builder.dataLabelFontConfiguration;
        this.visualTitleFontConfiguration = builder.visualTitleFontConfiguration;
        this.visualSubtitleFontConfiguration = builder.visualSubtitleFontConfiguration;
    }

    public final boolean hasFontFamilies() {
        return this.fontFamilies != null && !(this.fontFamilies instanceof SdkAutoConstructList);
    }

    public final List<Font> fontFamilies() {
        return this.fontFamilies;
    }

    public final FontConfiguration axisTitleFontConfiguration() {
        return this.axisTitleFontConfiguration;
    }

    public final FontConfiguration axisLabelFontConfiguration() {
        return this.axisLabelFontConfiguration;
    }

    public final FontConfiguration legendTitleFontConfiguration() {
        return this.legendTitleFontConfiguration;
    }

    public final FontConfiguration legendValueFontConfiguration() {
        return this.legendValueFontConfiguration;
    }

    public final FontConfiguration dataLabelFontConfiguration() {
        return this.dataLabelFontConfiguration;
    }

    public final VisualTitleFontConfiguration visualTitleFontConfiguration() {
        return this.visualTitleFontConfiguration;
    }

    public final VisualSubtitleFontConfiguration visualSubtitleFontConfiguration() {
        return this.visualSubtitleFontConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFontFamilies() ? this.fontFamilies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.axisTitleFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.axisLabelFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.legendTitleFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.legendValueFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLabelFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualTitleFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualSubtitleFontConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Typography)) {
            return false;
        }
        Typography other = (Typography)obj;
        return this.hasFontFamilies() == other.hasFontFamilies() && Objects.equals(this.fontFamilies(), other.fontFamilies()) && Objects.equals(this.axisTitleFontConfiguration(), other.axisTitleFontConfiguration()) && Objects.equals(this.axisLabelFontConfiguration(), other.axisLabelFontConfiguration()) && Objects.equals(this.legendTitleFontConfiguration(), other.legendTitleFontConfiguration()) && Objects.equals(this.legendValueFontConfiguration(), other.legendValueFontConfiguration()) && Objects.equals(this.dataLabelFontConfiguration(), other.dataLabelFontConfiguration()) && Objects.equals(this.visualTitleFontConfiguration(), other.visualTitleFontConfiguration()) && Objects.equals(this.visualSubtitleFontConfiguration(), other.visualSubtitleFontConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Typography").add("FontFamilies", this.hasFontFamilies() ? this.fontFamilies() : null).add("AxisTitleFontConfiguration", (Object)this.axisTitleFontConfiguration()).add("AxisLabelFontConfiguration", (Object)this.axisLabelFontConfiguration()).add("LegendTitleFontConfiguration", (Object)this.legendTitleFontConfiguration()).add("LegendValueFontConfiguration", (Object)this.legendValueFontConfiguration()).add("DataLabelFontConfiguration", (Object)this.dataLabelFontConfiguration()).add("VisualTitleFontConfiguration", (Object)this.visualTitleFontConfiguration()).add("VisualSubtitleFontConfiguration", (Object)this.visualSubtitleFontConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontFamilies": {
                return Optional.ofNullable(clazz.cast(this.fontFamilies()));
            }
            case "AxisTitleFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.axisTitleFontConfiguration()));
            }
            case "AxisLabelFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.axisLabelFontConfiguration()));
            }
            case "LegendTitleFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.legendTitleFontConfiguration()));
            }
            case "LegendValueFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.legendValueFontConfiguration()));
            }
            case "DataLabelFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataLabelFontConfiguration()));
            }
            case "VisualTitleFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.visualTitleFontConfiguration()));
            }
            case "VisualSubtitleFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.visualSubtitleFontConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FontFamilies", FONT_FAMILIES_FIELD);
        map.put("AxisTitleFontConfiguration", AXIS_TITLE_FONT_CONFIGURATION_FIELD);
        map.put("AxisLabelFontConfiguration", AXIS_LABEL_FONT_CONFIGURATION_FIELD);
        map.put("LegendTitleFontConfiguration", LEGEND_TITLE_FONT_CONFIGURATION_FIELD);
        map.put("LegendValueFontConfiguration", LEGEND_VALUE_FONT_CONFIGURATION_FIELD);
        map.put("DataLabelFontConfiguration", DATA_LABEL_FONT_CONFIGURATION_FIELD);
        map.put("VisualTitleFontConfiguration", VISUAL_TITLE_FONT_CONFIGURATION_FIELD);
        map.put("VisualSubtitleFontConfiguration", VISUAL_SUBTITLE_FONT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Typography, T> g) {
        return obj -> g.apply((Typography)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Font> fontFamilies = DefaultSdkAutoConstructList.getInstance();
        private FontConfiguration axisTitleFontConfiguration;
        private FontConfiguration axisLabelFontConfiguration;
        private FontConfiguration legendTitleFontConfiguration;
        private FontConfiguration legendValueFontConfiguration;
        private FontConfiguration dataLabelFontConfiguration;
        private VisualTitleFontConfiguration visualTitleFontConfiguration;
        private VisualSubtitleFontConfiguration visualSubtitleFontConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Typography model) {
            this.fontFamilies(model.fontFamilies);
            this.axisTitleFontConfiguration(model.axisTitleFontConfiguration);
            this.axisLabelFontConfiguration(model.axisLabelFontConfiguration);
            this.legendTitleFontConfiguration(model.legendTitleFontConfiguration);
            this.legendValueFontConfiguration(model.legendValueFontConfiguration);
            this.dataLabelFontConfiguration(model.dataLabelFontConfiguration);
            this.visualTitleFontConfiguration(model.visualTitleFontConfiguration);
            this.visualSubtitleFontConfiguration(model.visualSubtitleFontConfiguration);
        }

        public final List<Font.Builder> getFontFamilies() {
            List<Font.Builder> result = FontListCopier.copyToBuilder(this.fontFamilies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFontFamilies(Collection<Font.BuilderImpl> fontFamilies) {
            this.fontFamilies = FontListCopier.copyFromBuilder(fontFamilies);
        }

        @Override
        public final Builder fontFamilies(Collection<Font> fontFamilies) {
            this.fontFamilies = FontListCopier.copy(fontFamilies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fontFamilies(Font ... fontFamilies) {
            this.fontFamilies(Arrays.asList(fontFamilies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fontFamilies(Consumer<Font.Builder> ... fontFamilies) {
            this.fontFamilies(Stream.of(fontFamilies).map(c -> (Font)((Font.Builder)Font.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FontConfiguration.Builder getAxisTitleFontConfiguration() {
            return this.axisTitleFontConfiguration != null ? this.axisTitleFontConfiguration.toBuilder() : null;
        }

        public final void setAxisTitleFontConfiguration(FontConfiguration.BuilderImpl axisTitleFontConfiguration) {
            this.axisTitleFontConfiguration = axisTitleFontConfiguration != null ? axisTitleFontConfiguration.build() : null;
        }

        @Override
        public final Builder axisTitleFontConfiguration(FontConfiguration axisTitleFontConfiguration) {
            this.axisTitleFontConfiguration = axisTitleFontConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getAxisLabelFontConfiguration() {
            return this.axisLabelFontConfiguration != null ? this.axisLabelFontConfiguration.toBuilder() : null;
        }

        public final void setAxisLabelFontConfiguration(FontConfiguration.BuilderImpl axisLabelFontConfiguration) {
            this.axisLabelFontConfiguration = axisLabelFontConfiguration != null ? axisLabelFontConfiguration.build() : null;
        }

        @Override
        public final Builder axisLabelFontConfiguration(FontConfiguration axisLabelFontConfiguration) {
            this.axisLabelFontConfiguration = axisLabelFontConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getLegendTitleFontConfiguration() {
            return this.legendTitleFontConfiguration != null ? this.legendTitleFontConfiguration.toBuilder() : null;
        }

        public final void setLegendTitleFontConfiguration(FontConfiguration.BuilderImpl legendTitleFontConfiguration) {
            this.legendTitleFontConfiguration = legendTitleFontConfiguration != null ? legendTitleFontConfiguration.build() : null;
        }

        @Override
        public final Builder legendTitleFontConfiguration(FontConfiguration legendTitleFontConfiguration) {
            this.legendTitleFontConfiguration = legendTitleFontConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getLegendValueFontConfiguration() {
            return this.legendValueFontConfiguration != null ? this.legendValueFontConfiguration.toBuilder() : null;
        }

        public final void setLegendValueFontConfiguration(FontConfiguration.BuilderImpl legendValueFontConfiguration) {
            this.legendValueFontConfiguration = legendValueFontConfiguration != null ? legendValueFontConfiguration.build() : null;
        }

        @Override
        public final Builder legendValueFontConfiguration(FontConfiguration legendValueFontConfiguration) {
            this.legendValueFontConfiguration = legendValueFontConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getDataLabelFontConfiguration() {
            return this.dataLabelFontConfiguration != null ? this.dataLabelFontConfiguration.toBuilder() : null;
        }

        public final void setDataLabelFontConfiguration(FontConfiguration.BuilderImpl dataLabelFontConfiguration) {
            this.dataLabelFontConfiguration = dataLabelFontConfiguration != null ? dataLabelFontConfiguration.build() : null;
        }

        @Override
        public final Builder dataLabelFontConfiguration(FontConfiguration dataLabelFontConfiguration) {
            this.dataLabelFontConfiguration = dataLabelFontConfiguration;
            return this;
        }

        public final VisualTitleFontConfiguration.Builder getVisualTitleFontConfiguration() {
            return this.visualTitleFontConfiguration != null ? this.visualTitleFontConfiguration.toBuilder() : null;
        }

        public final void setVisualTitleFontConfiguration(VisualTitleFontConfiguration.BuilderImpl visualTitleFontConfiguration) {
            this.visualTitleFontConfiguration = visualTitleFontConfiguration != null ? visualTitleFontConfiguration.build() : null;
        }

        @Override
        public final Builder visualTitleFontConfiguration(VisualTitleFontConfiguration visualTitleFontConfiguration) {
            this.visualTitleFontConfiguration = visualTitleFontConfiguration;
            return this;
        }

        public final VisualSubtitleFontConfiguration.Builder getVisualSubtitleFontConfiguration() {
            return this.visualSubtitleFontConfiguration != null ? this.visualSubtitleFontConfiguration.toBuilder() : null;
        }

        public final void setVisualSubtitleFontConfiguration(VisualSubtitleFontConfiguration.BuilderImpl visualSubtitleFontConfiguration) {
            this.visualSubtitleFontConfiguration = visualSubtitleFontConfiguration != null ? visualSubtitleFontConfiguration.build() : null;
        }

        @Override
        public final Builder visualSubtitleFontConfiguration(VisualSubtitleFontConfiguration visualSubtitleFontConfiguration) {
            this.visualSubtitleFontConfiguration = visualSubtitleFontConfiguration;
            return this;
        }

        public Typography build() {
            return new Typography(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Typography> {
        public Builder fontFamilies(Collection<Font> var1);

        public Builder fontFamilies(Font ... var1);

        public Builder fontFamilies(Consumer<Font.Builder> ... var1);

        public Builder axisTitleFontConfiguration(FontConfiguration var1);

        default public Builder axisTitleFontConfiguration(Consumer<FontConfiguration.Builder> axisTitleFontConfiguration) {
            return this.axisTitleFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(axisTitleFontConfiguration)).build());
        }

        public Builder axisLabelFontConfiguration(FontConfiguration var1);

        default public Builder axisLabelFontConfiguration(Consumer<FontConfiguration.Builder> axisLabelFontConfiguration) {
            return this.axisLabelFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(axisLabelFontConfiguration)).build());
        }

        public Builder legendTitleFontConfiguration(FontConfiguration var1);

        default public Builder legendTitleFontConfiguration(Consumer<FontConfiguration.Builder> legendTitleFontConfiguration) {
            return this.legendTitleFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(legendTitleFontConfiguration)).build());
        }

        public Builder legendValueFontConfiguration(FontConfiguration var1);

        default public Builder legendValueFontConfiguration(Consumer<FontConfiguration.Builder> legendValueFontConfiguration) {
            return this.legendValueFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(legendValueFontConfiguration)).build());
        }

        public Builder dataLabelFontConfiguration(FontConfiguration var1);

        default public Builder dataLabelFontConfiguration(Consumer<FontConfiguration.Builder> dataLabelFontConfiguration) {
            return this.dataLabelFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(dataLabelFontConfiguration)).build());
        }

        public Builder visualTitleFontConfiguration(VisualTitleFontConfiguration var1);

        default public Builder visualTitleFontConfiguration(Consumer<VisualTitleFontConfiguration.Builder> visualTitleFontConfiguration) {
            return this.visualTitleFontConfiguration((VisualTitleFontConfiguration)((VisualTitleFontConfiguration.Builder)VisualTitleFontConfiguration.builder().applyMutation(visualTitleFontConfiguration)).build());
        }

        public Builder visualSubtitleFontConfiguration(VisualSubtitleFontConfiguration var1);

        default public Builder visualSubtitleFontConfiguration(Consumer<VisualSubtitleFontConfiguration.Builder> visualSubtitleFontConfiguration) {
            return this.visualSubtitleFontConfiguration((VisualSubtitleFontConfiguration)((VisualSubtitleFontConfiguration.Builder)VisualSubtitleFontConfiguration.builder().applyMutation(visualSubtitleFontConfiguration)).build());
        }
    }
}

