/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.PivotedLabel;
import software.amazon.awssdk.services.quicksight.model.PivotedLabelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotConfiguration> {
    private static final SdkField<String> LABEL_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelColumnName").getter(PivotConfiguration.getter(PivotConfiguration::labelColumnName)).setter(PivotConfiguration.setter(Builder::labelColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelColumnName").build()}).build();
    private static final SdkField<List<PivotedLabel>> PIVOTED_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PivotedLabels").getter(PivotConfiguration.getter(PivotConfiguration::pivotedLabels)).setter(PivotConfiguration.setter(Builder::pivotedLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotedLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PivotedLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_COLUMN_NAME_FIELD, PIVOTED_LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PivotConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String labelColumnName;
    private final List<PivotedLabel> pivotedLabels;

    private PivotConfiguration(BuilderImpl builder) {
        this.labelColumnName = builder.labelColumnName;
        this.pivotedLabels = builder.pivotedLabels;
    }

    public final String labelColumnName() {
        return this.labelColumnName;
    }

    public final boolean hasPivotedLabels() {
        return this.pivotedLabels != null && !(this.pivotedLabels instanceof SdkAutoConstructList);
    }

    public final List<PivotedLabel> pivotedLabels() {
        return this.pivotedLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPivotedLabels() ? this.pivotedLabels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotConfiguration)) {
            return false;
        }
        PivotConfiguration other = (PivotConfiguration)obj;
        return Objects.equals(this.labelColumnName(), other.labelColumnName()) && this.hasPivotedLabels() == other.hasPivotedLabels() && Objects.equals(this.pivotedLabels(), other.pivotedLabels());
    }

    public final String toString() {
        return ToString.builder((String)"PivotConfiguration").add("LabelColumnName", (Object)this.labelColumnName()).add("PivotedLabels", this.hasPivotedLabels() ? this.pivotedLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelColumnName": {
                return Optional.ofNullable(clazz.cast(this.labelColumnName()));
            }
            case "PivotedLabels": {
                return Optional.ofNullable(clazz.cast(this.pivotedLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LabelColumnName", LABEL_COLUMN_NAME_FIELD);
        map.put("PivotedLabels", PIVOTED_LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotConfiguration, T> g) {
        return obj -> g.apply((PivotConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String labelColumnName;
        private List<PivotedLabel> pivotedLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotConfiguration model) {
            this.labelColumnName(model.labelColumnName);
            this.pivotedLabels(model.pivotedLabels);
        }

        public final String getLabelColumnName() {
            return this.labelColumnName;
        }

        public final void setLabelColumnName(String labelColumnName) {
            this.labelColumnName = labelColumnName;
        }

        @Override
        public final Builder labelColumnName(String labelColumnName) {
            this.labelColumnName = labelColumnName;
            return this;
        }

        public final List<PivotedLabel.Builder> getPivotedLabels() {
            List<PivotedLabel.Builder> result = PivotedLabelListCopier.copyToBuilder(this.pivotedLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPivotedLabels(Collection<PivotedLabel.BuilderImpl> pivotedLabels) {
            this.pivotedLabels = PivotedLabelListCopier.copyFromBuilder(pivotedLabels);
        }

        @Override
        public final Builder pivotedLabels(Collection<PivotedLabel> pivotedLabels) {
            this.pivotedLabels = PivotedLabelListCopier.copy(pivotedLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pivotedLabels(PivotedLabel ... pivotedLabels) {
            this.pivotedLabels(Arrays.asList(pivotedLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pivotedLabels(Consumer<PivotedLabel.Builder> ... pivotedLabels) {
            this.pivotedLabels(Stream.of(pivotedLabels).map(c -> (PivotedLabel)((PivotedLabel.Builder)PivotedLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PivotConfiguration build() {
            return new PivotConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotConfiguration> {
        public Builder labelColumnName(String var1);

        public Builder pivotedLabels(Collection<PivotedLabel> var1);

        public Builder pivotedLabels(PivotedLabel ... var1);

        public Builder pivotedLabels(Consumer<PivotedLabel.Builder> ... var1);
    }
}

