/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DateAggregationFunction {
    COUNT("COUNT"),
    DISTINCT_COUNT("DISTINCT_COUNT"),
    MIN("MIN"),
    MAX("MAX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DateAggregationFunction> VALUE_MAP;
    private final String value;

    private DateAggregationFunction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DateAggregationFunction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DateAggregationFunction> knownValues() {
        EnumSet<DateAggregationFunction> knownValues = EnumSet.allOf(DateAggregationFunction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DateAggregationFunction.class, DateAggregationFunction::toString);
    }
}

