/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AuthorizationCodeGrantCredentialsDetails;
import software.amazon.awssdk.services.quicksight.model.AuthorizationCodeGrantCredentialsSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizationCodeGrantMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizationCodeGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseEndpoint").getter(AuthorizationCodeGrantMetadata.getter(AuthorizationCodeGrantMetadata::baseEndpoint)).setter(AuthorizationCodeGrantMetadata.setter(Builder::baseEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectUrl").getter(AuthorizationCodeGrantMetadata.getter(AuthorizationCodeGrantMetadata::redirectUrl)).setter(AuthorizationCodeGrantMetadata.setter(Builder::redirectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUrl").build()}).build();
    private static final SdkField<String> AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationCodeGrantCredentialsSource").getter(AuthorizationCodeGrantMetadata.getter(AuthorizationCodeGrantMetadata::authorizationCodeGrantCredentialsSourceAsString)).setter(AuthorizationCodeGrantMetadata.setter(Builder::authorizationCodeGrantCredentialsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantCredentialsSource").build()}).build();
    private static final SdkField<AuthorizationCodeGrantCredentialsDetails> AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthorizationCodeGrantCredentialsDetails").getter(AuthorizationCodeGrantMetadata.getter(AuthorizationCodeGrantMetadata::authorizationCodeGrantCredentialsDetails)).setter(AuthorizationCodeGrantMetadata.setter(Builder::authorizationCodeGrantCredentialsDetails)).constructor(AuthorizationCodeGrantCredentialsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantCredentialsDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD, REDIRECT_URL_FIELD, AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD, AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizationCodeGrantMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseEndpoint;
    private final String redirectUrl;
    private final String authorizationCodeGrantCredentialsSource;
    private final AuthorizationCodeGrantCredentialsDetails authorizationCodeGrantCredentialsDetails;

    private AuthorizationCodeGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.redirectUrl = builder.redirectUrl;
        this.authorizationCodeGrantCredentialsSource = builder.authorizationCodeGrantCredentialsSource;
        this.authorizationCodeGrantCredentialsDetails = builder.authorizationCodeGrantCredentialsDetails;
    }

    public final String baseEndpoint() {
        return this.baseEndpoint;
    }

    public final String redirectUrl() {
        return this.redirectUrl;
    }

    public final AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource() {
        return AuthorizationCodeGrantCredentialsSource.fromValue(this.authorizationCodeGrantCredentialsSource);
    }

    public final String authorizationCodeGrantCredentialsSourceAsString() {
        return this.authorizationCodeGrantCredentialsSource;
    }

    public final AuthorizationCodeGrantCredentialsDetails authorizationCodeGrantCredentialsDetails() {
        return this.authorizationCodeGrantCredentialsDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeGrantCredentialsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeGrantCredentialsDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationCodeGrantMetadata)) {
            return false;
        }
        AuthorizationCodeGrantMetadata other = (AuthorizationCodeGrantMetadata)obj;
        return Objects.equals(this.baseEndpoint(), other.baseEndpoint()) && Objects.equals(this.redirectUrl(), other.redirectUrl()) && Objects.equals(this.authorizationCodeGrantCredentialsSourceAsString(), other.authorizationCodeGrantCredentialsSourceAsString()) && Objects.equals(this.authorizationCodeGrantCredentialsDetails(), other.authorizationCodeGrantCredentialsDetails());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizationCodeGrantMetadata").add("BaseEndpoint", (Object)this.baseEndpoint()).add("RedirectUrl", (Object)this.redirectUrl()).add("AuthorizationCodeGrantCredentialsSource", (Object)this.authorizationCodeGrantCredentialsSourceAsString()).add("AuthorizationCodeGrantCredentialsDetails", (Object)this.authorizationCodeGrantCredentialsDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseEndpoint": {
                return Optional.ofNullable(clazz.cast(this.baseEndpoint()));
            }
            case "RedirectUrl": {
                return Optional.ofNullable(clazz.cast(this.redirectUrl()));
            }
            case "AuthorizationCodeGrantCredentialsSource": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeGrantCredentialsSourceAsString()));
            }
            case "AuthorizationCodeGrantCredentialsDetails": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeGrantCredentialsDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("RedirectUrl", REDIRECT_URL_FIELD);
        map.put("AuthorizationCodeGrantCredentialsSource", AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD);
        map.put("AuthorizationCodeGrantCredentialsDetails", AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationCodeGrantMetadata, T> g) {
        return obj -> g.apply((AuthorizationCodeGrantMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseEndpoint;
        private String redirectUrl;
        private String authorizationCodeGrantCredentialsSource;
        private AuthorizationCodeGrantCredentialsDetails authorizationCodeGrantCredentialsDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationCodeGrantMetadata model) {
            this.baseEndpoint(model.baseEndpoint);
            this.redirectUrl(model.redirectUrl);
            this.authorizationCodeGrantCredentialsSource(model.authorizationCodeGrantCredentialsSource);
            this.authorizationCodeGrantCredentialsDetails(model.authorizationCodeGrantCredentialsDetails);
        }

        public final String getBaseEndpoint() {
            return this.baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getRedirectUrl() {
            return this.redirectUrl;
        }

        public final void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Override
        public final Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final String getAuthorizationCodeGrantCredentialsSource() {
            return this.authorizationCodeGrantCredentialsSource;
        }

        public final void setAuthorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource = authorizationCodeGrantCredentialsSource;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource = authorizationCodeGrantCredentialsSource;
            return this;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsSource(AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource(authorizationCodeGrantCredentialsSource == null ? null : authorizationCodeGrantCredentialsSource.toString());
            return this;
        }

        public final AuthorizationCodeGrantCredentialsDetails.Builder getAuthorizationCodeGrantCredentialsDetails() {
            return this.authorizationCodeGrantCredentialsDetails != null ? this.authorizationCodeGrantCredentialsDetails.toBuilder() : null;
        }

        public final void setAuthorizationCodeGrantCredentialsDetails(AuthorizationCodeGrantCredentialsDetails.BuilderImpl authorizationCodeGrantCredentialsDetails) {
            this.authorizationCodeGrantCredentialsDetails = authorizationCodeGrantCredentialsDetails != null ? authorizationCodeGrantCredentialsDetails.build() : null;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsDetails(AuthorizationCodeGrantCredentialsDetails authorizationCodeGrantCredentialsDetails) {
            this.authorizationCodeGrantCredentialsDetails = authorizationCodeGrantCredentialsDetails;
            return this;
        }

        public AuthorizationCodeGrantMetadata build() {
            return new AuthorizationCodeGrantMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizationCodeGrantMetadata> {
        public Builder baseEndpoint(String var1);

        public Builder redirectUrl(String var1);

        public Builder authorizationCodeGrantCredentialsSource(String var1);

        public Builder authorizationCodeGrantCredentialsSource(AuthorizationCodeGrantCredentialsSource var1);

        public Builder authorizationCodeGrantCredentialsDetails(AuthorizationCodeGrantCredentialsDetails var1);

        default public Builder authorizationCodeGrantCredentialsDetails(Consumer<AuthorizationCodeGrantCredentialsDetails.Builder> authorizationCodeGrantCredentialsDetails) {
            return this.authorizationCodeGrantCredentialsDetails((AuthorizationCodeGrantCredentialsDetails)((AuthorizationCodeGrantCredentialsDetails.Builder)AuthorizationCodeGrantCredentialsDetails.builder().applyMutation(authorizationCodeGrantCredentialsDetails)).build());
        }
    }
}

