/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ProjectedColumnNameListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(ProjectOperation.getter(ProjectOperation::alias)).setter(ProjectOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ProjectOperation.getter(ProjectOperation::source)).setter(ProjectOperation.setter(Builder::source)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> PROJECTED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProjectedColumns").getter(ProjectOperation.getter(ProjectOperation::projectedColumns)).setter(ProjectOperation.setter(Builder::projectedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD, PROJECTED_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource source;
    private final List<String> projectedColumns;

    private ProjectOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.projectedColumns = builder.projectedColumns;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource source() {
        return this.source;
    }

    public final boolean hasProjectedColumns() {
        return this.projectedColumns != null && !(this.projectedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> projectedColumns() {
        return this.projectedColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedColumns() ? this.projectedColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectOperation)) {
            return false;
        }
        ProjectOperation other = (ProjectOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.source(), other.source()) && this.hasProjectedColumns() == other.hasProjectedColumns() && Objects.equals(this.projectedColumns(), other.projectedColumns());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectOperation").add("Alias", (Object)this.alias()).add("Source", (Object)this.source()).add("ProjectedColumns", this.hasProjectedColumns() ? this.projectedColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ProjectedColumns": {
                return Optional.ofNullable(clazz.cast(this.projectedColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ProjectedColumns", PROJECTED_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectOperation, T> g) {
        return obj -> g.apply((ProjectOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource source;
        private List<String> projectedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectOperation model) {
            this.alias(model.alias);
            this.source(model.source);
            this.projectedColumns(model.projectedColumns);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getProjectedColumns() {
            if (this.projectedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.projectedColumns;
        }

        public final void setProjectedColumns(Collection<String> projectedColumns) {
            this.projectedColumns = ProjectedColumnNameListCopier.copy(projectedColumns);
        }

        @Override
        public final Builder projectedColumns(Collection<String> projectedColumns) {
            this.projectedColumns = ProjectedColumnNameListCopier.copy(projectedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedColumns(String ... projectedColumns) {
            this.projectedColumns(Arrays.asList(projectedColumns));
            return this;
        }

        public ProjectOperation build() {
            return new ProjectOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectOperation> {
        public Builder alias(String var1);

        public Builder source(TransformOperationSource var1);

        default public Builder source(Consumer<TransformOperationSource.Builder> source) {
            return this.source((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(source)).build());
        }

        public Builder projectedColumns(Collection<String> var1);

        public Builder projectedColumns(String ... var1);
    }
}

