/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FlowPublishState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(FlowSummary.getter(FlowSummary::arn)).setter(FlowSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowId").getter(FlowSummary.getter(FlowSummary::flowId)).setter(FlowSummary.setter(Builder::flowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FlowSummary.getter(FlowSummary::name)).setter(FlowSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(FlowSummary.getter(FlowSummary::description)).setter(FlowSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(FlowSummary.getter(FlowSummary::createdTime)).setter(FlowSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(FlowSummary.getter(FlowSummary::createdBy)).setter(FlowSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(FlowSummary.getter(FlowSummary::lastUpdatedTime)).setter(FlowSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedBy").getter(FlowSummary.getter(FlowSummary::lastUpdatedBy)).setter(FlowSummary.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()}).build();
    private static final SdkField<String> PUBLISH_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishState").getter(FlowSummary.getter(FlowSummary::publishStateAsString)).setter(FlowSummary.setter(Builder::publishState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishState").build()}).build();
    private static final SdkField<Integer> RUN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunCount").getter(FlowSummary.getter(FlowSummary::runCount)).setter(FlowSummary.setter(Builder::runCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCount").build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserCount").getter(FlowSummary.getter(FlowSummary::userCount)).setter(FlowSummary.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()}).build();
    private static final SdkField<String> LAST_PUBLISHED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastPublishedBy").getter(FlowSummary.getter(FlowSummary::lastPublishedBy)).setter(FlowSummary.setter(Builder::lastPublishedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedBy").build()}).build();
    private static final SdkField<Instant> LAST_PUBLISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastPublishedAt").getter(FlowSummary.getter(FlowSummary::lastPublishedAt)).setter(FlowSummary.setter(Builder::lastPublishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD, PUBLISH_STATE_FIELD, RUN_COUNT_FIELD, USER_COUNT_FIELD, LAST_PUBLISHED_BY_FIELD, LAST_PUBLISHED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String flowId;
    private final String name;
    private final String description;
    private final Instant createdTime;
    private final String createdBy;
    private final Instant lastUpdatedTime;
    private final String lastUpdatedBy;
    private final String publishState;
    private final Integer runCount;
    private final Integer userCount;
    private final String lastPublishedBy;
    private final Instant lastPublishedAt;

    private FlowSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.flowId = builder.flowId;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.publishState = builder.publishState;
        this.runCount = builder.runCount;
        this.userCount = builder.userCount;
        this.lastPublishedBy = builder.lastPublishedBy;
        this.lastPublishedAt = builder.lastPublishedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String flowId() {
        return this.flowId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final FlowPublishState publishState() {
        return FlowPublishState.fromValue(this.publishState);
    }

    public final String publishStateAsString() {
        return this.publishState;
    }

    public final Integer runCount() {
        return this.runCount;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final String lastPublishedBy() {
        return this.lastPublishedBy;
    }

    public final Instant lastPublishedAt() {
        return this.lastPublishedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPublishedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPublishedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowSummary)) {
            return false;
        }
        FlowSummary other = (FlowSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.flowId(), other.flowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(this.publishStateAsString(), other.publishStateAsString()) && Objects.equals(this.runCount(), other.runCount()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.lastPublishedBy(), other.lastPublishedBy()) && Objects.equals(this.lastPublishedAt(), other.lastPublishedAt());
    }

    public final String toString() {
        return ToString.builder((String)"FlowSummary").add("Arn", (Object)this.arn()).add("FlowId", (Object)this.flowId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedTime", (Object)this.createdTime()).add("CreatedBy", (Object)this.createdBy()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("PublishState", (Object)this.publishStateAsString()).add("RunCount", (Object)this.runCount()).add("UserCount", (Object)this.userCount()).add("LastPublishedBy", (Object)this.lastPublishedBy()).add("LastPublishedAt", (Object)this.lastPublishedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "FlowId": {
                return Optional.ofNullable(clazz.cast(this.flowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "PublishState": {
                return Optional.ofNullable(clazz.cast(this.publishStateAsString()));
            }
            case "RunCount": {
                return Optional.ofNullable(clazz.cast(this.runCount()));
            }
            case "UserCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "LastPublishedBy": {
                return Optional.ofNullable(clazz.cast(this.lastPublishedBy()));
            }
            case "LastPublishedAt": {
                return Optional.ofNullable(clazz.cast(this.lastPublishedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("FlowId", FLOW_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("PublishState", PUBLISH_STATE_FIELD);
        map.put("RunCount", RUN_COUNT_FIELD);
        map.put("UserCount", USER_COUNT_FIELD);
        map.put("LastPublishedBy", LAST_PUBLISHED_BY_FIELD);
        map.put("LastPublishedAt", LAST_PUBLISHED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowSummary, T> g) {
        return obj -> g.apply((FlowSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String flowId;
        private String name;
        private String description;
        private Instant createdTime;
        private String createdBy;
        private Instant lastUpdatedTime;
        private String lastUpdatedBy;
        private String publishState;
        private Integer runCount;
        private Integer userCount;
        private String lastPublishedBy;
        private Instant lastPublishedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowSummary model) {
            this.arn(model.arn);
            this.flowId(model.flowId);
            this.name(model.name);
            this.description(model.description);
            this.createdTime(model.createdTime);
            this.createdBy(model.createdBy);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.publishState(model.publishState);
            this.runCount(model.runCount);
            this.userCount(model.userCount);
            this.lastPublishedBy(model.lastPublishedBy);
            this.lastPublishedAt(model.lastPublishedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFlowId() {
            return this.flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getPublishState() {
            return this.publishState;
        }

        public final void setPublishState(String publishState) {
            this.publishState = publishState;
        }

        @Override
        public final Builder publishState(String publishState) {
            this.publishState = publishState;
            return this;
        }

        @Override
        public final Builder publishState(FlowPublishState publishState) {
            this.publishState(publishState == null ? null : publishState.toString());
            return this;
        }

        public final Integer getRunCount() {
            return this.runCount;
        }

        public final void setRunCount(Integer runCount) {
            this.runCount = runCount;
        }

        @Override
        public final Builder runCount(Integer runCount) {
            this.runCount = runCount;
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final String getLastPublishedBy() {
            return this.lastPublishedBy;
        }

        public final void setLastPublishedBy(String lastPublishedBy) {
            this.lastPublishedBy = lastPublishedBy;
        }

        @Override
        public final Builder lastPublishedBy(String lastPublishedBy) {
            this.lastPublishedBy = lastPublishedBy;
            return this;
        }

        public final Instant getLastPublishedAt() {
            return this.lastPublishedAt;
        }

        public final void setLastPublishedAt(Instant lastPublishedAt) {
            this.lastPublishedAt = lastPublishedAt;
        }

        @Override
        public final Builder lastPublishedAt(Instant lastPublishedAt) {
            this.lastPublishedAt = lastPublishedAt;
            return this;
        }

        public FlowSummary build() {
            return new FlowSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowSummary> {
        public Builder arn(String var1);

        public Builder flowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder lastUpdatedBy(String var1);

        public Builder publishState(String var1);

        public Builder publishState(FlowPublishState var1);

        public Builder runCount(Integer var1);

        public Builder userCount(Integer var1);

        public Builder lastPublishedBy(String var1);

        public Builder lastPublishedAt(Instant var1);
    }
}

