/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnHierarchy;
import software.amazon.awssdk.services.quicksight.model.ColumnHierarchyListCopier;
import software.amazon.awssdk.services.quicksight.model.FilledMapConditionalFormatting;
import software.amazon.awssdk.services.quicksight.model.FilledMapConfiguration;
import software.amazon.awssdk.services.quicksight.model.GeocodePreference;
import software.amazon.awssdk.services.quicksight.model.GeocodePreferenceListCopier;
import software.amazon.awssdk.services.quicksight.model.VisualCustomAction;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionListCopier;
import software.amazon.awssdk.services.quicksight.model.VisualSubtitleLabelOptions;
import software.amazon.awssdk.services.quicksight.model.VisualTitleLabelOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilledMapVisual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilledMapVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(FilledMapVisual.getter(FilledMapVisual::visualId)).setter(FilledMapVisual.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Title").getter(FilledMapVisual.getter(FilledMapVisual::title)).setter(FilledMapVisual.setter(Builder::title)).constructor(VisualTitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subtitle").getter(FilledMapVisual.getter(FilledMapVisual::subtitle)).setter(FilledMapVisual.setter(Builder::subtitle)).constructor(VisualSubtitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()}).build();
    private static final SdkField<FilledMapConfiguration> CHART_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChartConfiguration").getter(FilledMapVisual.getter(FilledMapVisual::chartConfiguration)).setter(FilledMapVisual.setter(Builder::chartConfiguration)).constructor(FilledMapConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartConfiguration").build()}).build();
    private static final SdkField<FilledMapConditionalFormatting> CONDITIONAL_FORMATTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConditionalFormatting").getter(FilledMapVisual.getter(FilledMapVisual::conditionalFormatting)).setter(FilledMapVisual.setter(Builder::conditionalFormatting)).constructor(FilledMapConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalFormatting").build()}).build();
    private static final SdkField<List<ColumnHierarchy>> COLUMN_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnHierarchies").getter(FilledMapVisual.getter(FilledMapVisual::columnHierarchies)).setter(FilledMapVisual.setter(Builder::columnHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VisualCustomAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(FilledMapVisual.getter(FilledMapVisual::actions)).setter(FilledMapVisual.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VisualCustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VISUAL_CONTENT_ALT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualContentAltText").getter(FilledMapVisual.getter(FilledMapVisual::visualContentAltText)).setter(FilledMapVisual.setter(Builder::visualContentAltText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualContentAltText").build()}).build();
    private static final SdkField<List<GeocodePreference>> GEOCODING_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GeocodingPreferences").getter(FilledMapVisual.getter(FilledMapVisual::geocodingPreferences)).setter(FilledMapVisual.setter(Builder::geocodingPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeocodingPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeocodePreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, TITLE_FIELD, SUBTITLE_FIELD, CHART_CONFIGURATION_FIELD, CONDITIONAL_FORMATTING_FIELD, COLUMN_HIERARCHIES_FIELD, ACTIONS_FIELD, VISUAL_CONTENT_ALT_TEXT_FIELD, GEOCODING_PREFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilledMapVisual.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visualId;
    private final VisualTitleLabelOptions title;
    private final VisualSubtitleLabelOptions subtitle;
    private final FilledMapConfiguration chartConfiguration;
    private final FilledMapConditionalFormatting conditionalFormatting;
    private final List<ColumnHierarchy> columnHierarchies;
    private final List<VisualCustomAction> actions;
    private final String visualContentAltText;
    private final List<GeocodePreference> geocodingPreferences;

    private FilledMapVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.chartConfiguration = builder.chartConfiguration;
        this.conditionalFormatting = builder.conditionalFormatting;
        this.columnHierarchies = builder.columnHierarchies;
        this.actions = builder.actions;
        this.visualContentAltText = builder.visualContentAltText;
        this.geocodingPreferences = builder.geocodingPreferences;
    }

    public final String visualId() {
        return this.visualId;
    }

    public final VisualTitleLabelOptions title() {
        return this.title;
    }

    public final VisualSubtitleLabelOptions subtitle() {
        return this.subtitle;
    }

    public final FilledMapConfiguration chartConfiguration() {
        return this.chartConfiguration;
    }

    public final FilledMapConditionalFormatting conditionalFormatting() {
        return this.conditionalFormatting;
    }

    public final boolean hasColumnHierarchies() {
        return this.columnHierarchies != null && !(this.columnHierarchies instanceof SdkAutoConstructList);
    }

    public final List<ColumnHierarchy> columnHierarchies() {
        return this.columnHierarchies;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<VisualCustomAction> actions() {
        return this.actions;
    }

    public final String visualContentAltText() {
        return this.visualContentAltText;
    }

    public final boolean hasGeocodingPreferences() {
        return this.geocodingPreferences != null && !(this.geocodingPreferences instanceof SdkAutoConstructList);
    }

    public final List<GeocodePreference> geocodingPreferences() {
        return this.geocodingPreferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.chartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalFormatting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnHierarchies() ? this.columnHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visualContentAltText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeocodingPreferences() ? this.geocodingPreferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilledMapVisual)) {
            return false;
        }
        FilledMapVisual other = (FilledMapVisual)obj;
        return Objects.equals(this.visualId(), other.visualId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.chartConfiguration(), other.chartConfiguration()) && Objects.equals(this.conditionalFormatting(), other.conditionalFormatting()) && this.hasColumnHierarchies() == other.hasColumnHierarchies() && Objects.equals(this.columnHierarchies(), other.columnHierarchies()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.visualContentAltText(), other.visualContentAltText()) && this.hasGeocodingPreferences() == other.hasGeocodingPreferences() && Objects.equals(this.geocodingPreferences(), other.geocodingPreferences());
    }

    public final String toString() {
        return ToString.builder((String)"FilledMapVisual").add("VisualId", (Object)this.visualId()).add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("ChartConfiguration", (Object)this.chartConfiguration()).add("ConditionalFormatting", (Object)this.conditionalFormatting()).add("ColumnHierarchies", this.hasColumnHierarchies() ? this.columnHierarchies() : null).add("Actions", this.hasActions() ? this.actions() : null).add("VisualContentAltText", (Object)this.visualContentAltText()).add("GeocodingPreferences", this.hasGeocodingPreferences() ? this.geocodingPreferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "ChartConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chartConfiguration()));
            }
            case "ConditionalFormatting": {
                return Optional.ofNullable(clazz.cast(this.conditionalFormatting()));
            }
            case "ColumnHierarchies": {
                return Optional.ofNullable(clazz.cast(this.columnHierarchies()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "VisualContentAltText": {
                return Optional.ofNullable(clazz.cast(this.visualContentAltText()));
            }
            case "GeocodingPreferences": {
                return Optional.ofNullable(clazz.cast(this.geocodingPreferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VisualId", VISUAL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Subtitle", SUBTITLE_FIELD);
        map.put("ChartConfiguration", CHART_CONFIGURATION_FIELD);
        map.put("ConditionalFormatting", CONDITIONAL_FORMATTING_FIELD);
        map.put("ColumnHierarchies", COLUMN_HIERARCHIES_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("VisualContentAltText", VISUAL_CONTENT_ALT_TEXT_FIELD);
        map.put("GeocodingPreferences", GEOCODING_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilledMapVisual, T> g) {
        return obj -> g.apply((FilledMapVisual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualId;
        private VisualTitleLabelOptions title;
        private VisualSubtitleLabelOptions subtitle;
        private FilledMapConfiguration chartConfiguration;
        private FilledMapConditionalFormatting conditionalFormatting;
        private List<ColumnHierarchy> columnHierarchies = DefaultSdkAutoConstructList.getInstance();
        private List<VisualCustomAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String visualContentAltText;
        private List<GeocodePreference> geocodingPreferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilledMapVisual model) {
            this.visualId(model.visualId);
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.chartConfiguration(model.chartConfiguration);
            this.conditionalFormatting(model.conditionalFormatting);
            this.columnHierarchies(model.columnHierarchies);
            this.actions(model.actions);
            this.visualContentAltText(model.visualContentAltText);
            this.geocodingPreferences(model.geocodingPreferences);
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return this.title != null ? this.title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return this.subtitle != null ? this.subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final FilledMapConfiguration.Builder getChartConfiguration() {
            return this.chartConfiguration != null ? this.chartConfiguration.toBuilder() : null;
        }

        public final void setChartConfiguration(FilledMapConfiguration.BuilderImpl chartConfiguration) {
            this.chartConfiguration = chartConfiguration != null ? chartConfiguration.build() : null;
        }

        @Override
        public final Builder chartConfiguration(FilledMapConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
            return this;
        }

        public final FilledMapConditionalFormatting.Builder getConditionalFormatting() {
            return this.conditionalFormatting != null ? this.conditionalFormatting.toBuilder() : null;
        }

        public final void setConditionalFormatting(FilledMapConditionalFormatting.BuilderImpl conditionalFormatting) {
            this.conditionalFormatting = conditionalFormatting != null ? conditionalFormatting.build() : null;
        }

        @Override
        public final Builder conditionalFormatting(FilledMapConditionalFormatting conditionalFormatting) {
            this.conditionalFormatting = conditionalFormatting;
            return this;
        }

        public final List<ColumnHierarchy.Builder> getColumnHierarchies() {
            List<ColumnHierarchy.Builder> result = ColumnHierarchyListCopier.copyToBuilder(this.columnHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnHierarchies(Collection<ColumnHierarchy.BuilderImpl> columnHierarchies) {
            this.columnHierarchies = ColumnHierarchyListCopier.copyFromBuilder(columnHierarchies);
        }

        @Override
        public final Builder columnHierarchies(Collection<ColumnHierarchy> columnHierarchies) {
            this.columnHierarchies = ColumnHierarchyListCopier.copy(columnHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnHierarchies(ColumnHierarchy ... columnHierarchies) {
            this.columnHierarchies(Arrays.asList(columnHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnHierarchies(Consumer<ColumnHierarchy.Builder> ... columnHierarchies) {
            this.columnHierarchies(Stream.of(columnHierarchies).map(c -> (ColumnHierarchy)((ColumnHierarchy.Builder)ColumnHierarchy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VisualCustomAction.Builder> getActions() {
            List<VisualCustomAction.Builder> result = VisualCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VisualCustomAction.BuilderImpl> actions) {
            this.actions = VisualCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<VisualCustomAction> actions) {
            this.actions = VisualCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VisualCustomAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VisualCustomAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (VisualCustomAction)((VisualCustomAction.Builder)VisualCustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVisualContentAltText() {
            return this.visualContentAltText;
        }

        public final void setVisualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
        }

        @Override
        public final Builder visualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
            return this;
        }

        public final List<GeocodePreference.Builder> getGeocodingPreferences() {
            List<GeocodePreference.Builder> result = GeocodePreferenceListCopier.copyToBuilder(this.geocodingPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeocodingPreferences(Collection<GeocodePreference.BuilderImpl> geocodingPreferences) {
            this.geocodingPreferences = GeocodePreferenceListCopier.copyFromBuilder(geocodingPreferences);
        }

        @Override
        public final Builder geocodingPreferences(Collection<GeocodePreference> geocodingPreferences) {
            this.geocodingPreferences = GeocodePreferenceListCopier.copy(geocodingPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geocodingPreferences(GeocodePreference ... geocodingPreferences) {
            this.geocodingPreferences(Arrays.asList(geocodingPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geocodingPreferences(Consumer<GeocodePreference.Builder> ... geocodingPreferences) {
            this.geocodingPreferences(Stream.of(geocodingPreferences).map(c -> (GeocodePreference)((GeocodePreference.Builder)GeocodePreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FilledMapVisual build() {
            return new FilledMapVisual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilledMapVisual> {
        public Builder visualId(String var1);

        public Builder title(VisualTitleLabelOptions var1);

        default public Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return this.title((VisualTitleLabelOptions)((VisualTitleLabelOptions.Builder)VisualTitleLabelOptions.builder().applyMutation(title)).build());
        }

        public Builder subtitle(VisualSubtitleLabelOptions var1);

        default public Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return this.subtitle((VisualSubtitleLabelOptions)((VisualSubtitleLabelOptions.Builder)VisualSubtitleLabelOptions.builder().applyMutation(subtitle)).build());
        }

        public Builder chartConfiguration(FilledMapConfiguration var1);

        default public Builder chartConfiguration(Consumer<FilledMapConfiguration.Builder> chartConfiguration) {
            return this.chartConfiguration((FilledMapConfiguration)((FilledMapConfiguration.Builder)FilledMapConfiguration.builder().applyMutation(chartConfiguration)).build());
        }

        public Builder conditionalFormatting(FilledMapConditionalFormatting var1);

        default public Builder conditionalFormatting(Consumer<FilledMapConditionalFormatting.Builder> conditionalFormatting) {
            return this.conditionalFormatting((FilledMapConditionalFormatting)((FilledMapConditionalFormatting.Builder)FilledMapConditionalFormatting.builder().applyMutation(conditionalFormatting)).build());
        }

        public Builder columnHierarchies(Collection<ColumnHierarchy> var1);

        public Builder columnHierarchies(ColumnHierarchy ... var1);

        public Builder columnHierarchies(Consumer<ColumnHierarchy.Builder> ... var1);

        public Builder actions(Collection<VisualCustomAction> var1);

        public Builder actions(VisualCustomAction ... var1);

        public Builder actions(Consumer<VisualCustomAction.Builder> ... var1);

        public Builder visualContentAltText(String var1);

        public Builder geocodingPreferences(Collection<GeocodePreference> var1);

        public Builder geocodingPreferences(GeocodePreference ... var1);

        public Builder geocodingPreferences(Consumer<GeocodePreference.Builder> ... var1);
    }
}

