/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CustomPermissions;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomPermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeCustomPermissionsResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeCustomPermissionsResponse.getter(DescribeCustomPermissionsResponse::status)).setter(DescribeCustomPermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CustomPermissions> CUSTOM_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomPermissions").getter(DescribeCustomPermissionsResponse.getter(DescribeCustomPermissionsResponse::customPermissions)).setter(DescribeCustomPermissionsResponse.setter(Builder::customPermissions)).constructor(CustomPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissions").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeCustomPermissionsResponse.getter(DescribeCustomPermissionsResponse::requestId)).setter(DescribeCustomPermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CUSTOM_PERMISSIONS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCustomPermissionsResponse.memberNameToFieldInitializer();
    private final Integer status;
    private final CustomPermissions customPermissions;
    private final String requestId;

    private DescribeCustomPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.customPermissions = builder.customPermissions;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final CustomPermissions customPermissions() {
        return this.customPermissions;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomPermissionsResponse)) {
            return false;
        }
        DescribeCustomPermissionsResponse other = (DescribeCustomPermissionsResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.customPermissions(), other.customPermissions()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomPermissionsResponse").add("Status", (Object)this.status()).add("CustomPermissions", (Object)this.customPermissions()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CustomPermissions": {
                return Optional.ofNullable(clazz.cast(this.customPermissions()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("CustomPermissions", CUSTOM_PERMISSIONS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeCustomPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private CustomPermissions customPermissions;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomPermissionsResponse model) {
            super(model);
            this.status(model.status);
            this.customPermissions(model.customPermissions);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final CustomPermissions.Builder getCustomPermissions() {
            return this.customPermissions != null ? this.customPermissions.toBuilder() : null;
        }

        public final void setCustomPermissions(CustomPermissions.BuilderImpl customPermissions) {
            this.customPermissions = customPermissions != null ? customPermissions.build() : null;
        }

        @Override
        public final Builder customPermissions(CustomPermissions customPermissions) {
            this.customPermissions = customPermissions;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeCustomPermissionsResponse build() {
            return new DescribeCustomPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomPermissionsResponse> {
        public Builder status(Integer var1);

        public Builder customPermissions(CustomPermissions var1);

        default public Builder customPermissions(Consumer<CustomPermissions.Builder> customPermissions) {
            return this.customPermissions((CustomPermissions)((CustomPermissions.Builder)CustomPermissions.builder().applyMutation(customPermissions)).build());
        }

        public Builder requestId(String var1);
    }
}

