/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FolderSummary;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersResponse;

public class SearchFoldersIterable
implements SdkIterable<SearchFoldersResponse> {
    private final QuickSightClient client;
    private final SearchFoldersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchFoldersIterable(QuickSightClient client, SearchFoldersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchFoldersResponseFetcher();
    }

    public Iterator<SearchFoldersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FolderSummary> folderSummaryList() {
        Function<SearchFoldersResponse, Iterator> getIterator = response -> {
            if (response != null && response.folderSummaryList() != null) {
                return response.folderSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchFoldersResponseFetcher
    implements SyncPageFetcher<SearchFoldersResponse> {
        private SearchFoldersResponseFetcher() {
        }

        public boolean hasNextPage(SearchFoldersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchFoldersResponse nextPage(SearchFoldersResponse previousPage) {
            if (previousPage == null) {
                return SearchFoldersIterable.this.client.searchFolders(SearchFoldersIterable.this.firstRequest);
            }
            return SearchFoldersIterable.this.client.searchFolders((SearchFoldersRequest)((Object)SearchFoldersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

