/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.IAMPolicyAssignmentSummary;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;

public class ListIAMPolicyAssignmentsIterable
implements SdkIterable<ListIamPolicyAssignmentsResponse> {
    private final QuickSightClient client;
    private final ListIamPolicyAssignmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIAMPolicyAssignmentsIterable(QuickSightClient client, ListIamPolicyAssignmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIamPolicyAssignmentsResponseFetcher();
    }

    public Iterator<ListIamPolicyAssignmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IAMPolicyAssignmentSummary> iamPolicyAssignments() {
        Function<ListIamPolicyAssignmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.iamPolicyAssignments() != null) {
                return response.iamPolicyAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIamPolicyAssignmentsResponseFetcher
    implements SyncPageFetcher<ListIamPolicyAssignmentsResponse> {
        private ListIamPolicyAssignmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListIamPolicyAssignmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIamPolicyAssignmentsResponse nextPage(ListIamPolicyAssignmentsResponse previousPage) {
            if (previousPage == null) {
                return ListIAMPolicyAssignmentsIterable.this.client.listIAMPolicyAssignments(ListIAMPolicyAssignmentsIterable.this.firstRequest);
            }
            return ListIAMPolicyAssignmentsIterable.this.client.listIAMPolicyAssignments((ListIamPolicyAssignmentsRequest)((Object)ListIAMPolicyAssignmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

