/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GeospatialCircleRadius;
import software.amazon.awssdk.services.quicksight.model.GeospatialColor;
import software.amazon.awssdk.services.quicksight.model.GeospatialLineWidth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialCircleSymbolStyle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialCircleSymbolStyle> {
    private static final SdkField<GeospatialColor> FILL_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FillColor").getter(GeospatialCircleSymbolStyle.getter(GeospatialCircleSymbolStyle::fillColor)).setter(GeospatialCircleSymbolStyle.setter(Builder::fillColor)).constructor(GeospatialColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillColor").build()}).build();
    private static final SdkField<GeospatialColor> STROKE_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StrokeColor").getter(GeospatialCircleSymbolStyle.getter(GeospatialCircleSymbolStyle::strokeColor)).setter(GeospatialCircleSymbolStyle.setter(Builder::strokeColor)).constructor(GeospatialColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrokeColor").build()}).build();
    private static final SdkField<GeospatialLineWidth> STROKE_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StrokeWidth").getter(GeospatialCircleSymbolStyle.getter(GeospatialCircleSymbolStyle::strokeWidth)).setter(GeospatialCircleSymbolStyle.setter(Builder::strokeWidth)).constructor(GeospatialLineWidth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrokeWidth").build()}).build();
    private static final SdkField<GeospatialCircleRadius> CIRCLE_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CircleRadius").getter(GeospatialCircleSymbolStyle.getter(GeospatialCircleSymbolStyle::circleRadius)).setter(GeospatialCircleSymbolStyle.setter(Builder::circleRadius)).constructor(GeospatialCircleRadius::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CircleRadius").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILL_COLOR_FIELD, STROKE_COLOR_FIELD, STROKE_WIDTH_FIELD, CIRCLE_RADIUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialCircleSymbolStyle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GeospatialColor fillColor;
    private final GeospatialColor strokeColor;
    private final GeospatialLineWidth strokeWidth;
    private final GeospatialCircleRadius circleRadius;

    private GeospatialCircleSymbolStyle(BuilderImpl builder) {
        this.fillColor = builder.fillColor;
        this.strokeColor = builder.strokeColor;
        this.strokeWidth = builder.strokeWidth;
        this.circleRadius = builder.circleRadius;
    }

    public final GeospatialColor fillColor() {
        return this.fillColor;
    }

    public final GeospatialColor strokeColor() {
        return this.strokeColor;
    }

    public final GeospatialLineWidth strokeWidth() {
        return this.strokeWidth;
    }

    public final GeospatialCircleRadius circleRadius() {
        return this.circleRadius;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fillColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.strokeColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.strokeWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.circleRadius());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialCircleSymbolStyle)) {
            return false;
        }
        GeospatialCircleSymbolStyle other = (GeospatialCircleSymbolStyle)obj;
        return Objects.equals(this.fillColor(), other.fillColor()) && Objects.equals(this.strokeColor(), other.strokeColor()) && Objects.equals(this.strokeWidth(), other.strokeWidth()) && Objects.equals(this.circleRadius(), other.circleRadius());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialCircleSymbolStyle").add("FillColor", (Object)this.fillColor()).add("StrokeColor", (Object)this.strokeColor()).add("StrokeWidth", (Object)this.strokeWidth()).add("CircleRadius", (Object)this.circleRadius()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FillColor": {
                return Optional.ofNullable(clazz.cast(this.fillColor()));
            }
            case "StrokeColor": {
                return Optional.ofNullable(clazz.cast(this.strokeColor()));
            }
            case "StrokeWidth": {
                return Optional.ofNullable(clazz.cast(this.strokeWidth()));
            }
            case "CircleRadius": {
                return Optional.ofNullable(clazz.cast(this.circleRadius()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FillColor", FILL_COLOR_FIELD);
        map.put("StrokeColor", STROKE_COLOR_FIELD);
        map.put("StrokeWidth", STROKE_WIDTH_FIELD);
        map.put("CircleRadius", CIRCLE_RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialCircleSymbolStyle, T> g) {
        return obj -> g.apply((GeospatialCircleSymbolStyle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GeospatialColor fillColor;
        private GeospatialColor strokeColor;
        private GeospatialLineWidth strokeWidth;
        private GeospatialCircleRadius circleRadius;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialCircleSymbolStyle model) {
            this.fillColor(model.fillColor);
            this.strokeColor(model.strokeColor);
            this.strokeWidth(model.strokeWidth);
            this.circleRadius(model.circleRadius);
        }

        public final GeospatialColor.Builder getFillColor() {
            return this.fillColor != null ? this.fillColor.toBuilder() : null;
        }

        public final void setFillColor(GeospatialColor.BuilderImpl fillColor) {
            this.fillColor = fillColor != null ? fillColor.build() : null;
        }

        @Override
        public final Builder fillColor(GeospatialColor fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public final GeospatialColor.Builder getStrokeColor() {
            return this.strokeColor != null ? this.strokeColor.toBuilder() : null;
        }

        public final void setStrokeColor(GeospatialColor.BuilderImpl strokeColor) {
            this.strokeColor = strokeColor != null ? strokeColor.build() : null;
        }

        @Override
        public final Builder strokeColor(GeospatialColor strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public final GeospatialLineWidth.Builder getStrokeWidth() {
            return this.strokeWidth != null ? this.strokeWidth.toBuilder() : null;
        }

        public final void setStrokeWidth(GeospatialLineWidth.BuilderImpl strokeWidth) {
            this.strokeWidth = strokeWidth != null ? strokeWidth.build() : null;
        }

        @Override
        public final Builder strokeWidth(GeospatialLineWidth strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public final GeospatialCircleRadius.Builder getCircleRadius() {
            return this.circleRadius != null ? this.circleRadius.toBuilder() : null;
        }

        public final void setCircleRadius(GeospatialCircleRadius.BuilderImpl circleRadius) {
            this.circleRadius = circleRadius != null ? circleRadius.build() : null;
        }

        @Override
        public final Builder circleRadius(GeospatialCircleRadius circleRadius) {
            this.circleRadius = circleRadius;
            return this;
        }

        public GeospatialCircleSymbolStyle build() {
            return new GeospatialCircleSymbolStyle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialCircleSymbolStyle> {
        public Builder fillColor(GeospatialColor var1);

        default public Builder fillColor(Consumer<GeospatialColor.Builder> fillColor) {
            return this.fillColor((GeospatialColor)((GeospatialColor.Builder)GeospatialColor.builder().applyMutation(fillColor)).build());
        }

        public Builder strokeColor(GeospatialColor var1);

        default public Builder strokeColor(Consumer<GeospatialColor.Builder> strokeColor) {
            return this.strokeColor((GeospatialColor)((GeospatialColor.Builder)GeospatialColor.builder().applyMutation(strokeColor)).build());
        }

        public Builder strokeWidth(GeospatialLineWidth var1);

        default public Builder strokeWidth(Consumer<GeospatialLineWidth.Builder> strokeWidth) {
            return this.strokeWidth((GeospatialLineWidth)((GeospatialLineWidth.Builder)GeospatialLineWidth.builder().applyMutation(strokeWidth)).build());
        }

        public Builder circleRadius(GeospatialCircleRadius var1);

        default public Builder circleRadius(Consumer<GeospatialCircleRadius.Builder> circleRadius) {
            return this.circleRadius((GeospatialCircleRadius)((GeospatialCircleRadius.Builder)GeospatialCircleRadius.builder().applyMutation(circleRadius)).build());
        }
    }
}

