/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CategoryValueListCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CategoryDrillDownFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CategoryDrillDownFilter> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(CategoryDrillDownFilter.getter(CategoryDrillDownFilter::column)).setter(CategoryDrillDownFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<List<String>> CATEGORY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategoryValues").getter(CategoryDrillDownFilter.getter(CategoryDrillDownFilter::categoryValues)).setter(CategoryDrillDownFilter.setter(Builder::categoryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, CATEGORY_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CategoryDrillDownFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final List<String> categoryValues;

    private CategoryDrillDownFilter(BuilderImpl builder) {
        this.column = builder.column;
        this.categoryValues = builder.categoryValues;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final boolean hasCategoryValues() {
        return this.categoryValues != null && !(this.categoryValues instanceof SdkAutoConstructList);
    }

    public final List<String> categoryValues() {
        return this.categoryValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategoryValues() ? this.categoryValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryDrillDownFilter)) {
            return false;
        }
        CategoryDrillDownFilter other = (CategoryDrillDownFilter)obj;
        return Objects.equals(this.column(), other.column()) && this.hasCategoryValues() == other.hasCategoryValues() && Objects.equals(this.categoryValues(), other.categoryValues());
    }

    public final String toString() {
        return ToString.builder((String)"CategoryDrillDownFilter").add("Column", (Object)this.column()).add("CategoryValues", this.hasCategoryValues() ? this.categoryValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "CategoryValues": {
                return Optional.ofNullable(clazz.cast(this.categoryValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Column", COLUMN_FIELD);
        map.put("CategoryValues", CATEGORY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CategoryDrillDownFilter, T> g) {
        return obj -> g.apply((CategoryDrillDownFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private List<String> categoryValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryDrillDownFilter model) {
            this.column(model.column);
            this.categoryValues(model.categoryValues);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Collection<String> getCategoryValues() {
            if (this.categoryValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categoryValues;
        }

        public final void setCategoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
        }

        @Override
        public final Builder categoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryValues(String ... categoryValues) {
            this.categoryValues(Arrays.asList(categoryValues));
            return this;
        }

        public CategoryDrillDownFilter build() {
            return new CategoryDrillDownFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CategoryDrillDownFilter> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder categoryValues(Collection<String> var1);

        public Builder categoryValues(String ... var1);
    }
}

