/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AxisBinding {
    PRIMARY_YAXIS("PRIMARY_YAXIS"),
    SECONDARY_YAXIS("SECONDARY_YAXIS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AxisBinding> VALUE_MAP;
    private final String value;

    private AxisBinding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AxisBinding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AxisBinding> knownValues() {
        EnumSet<AxisBinding> knownValues = EnumSet.allOf(AxisBinding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AxisBinding.class, AxisBinding::toString);
    }
}

