/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketConfiguration> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3BucketConfiguration.getter(S3BucketConfiguration::bucketName)).setter(S3BucketConfiguration.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketPrefix").getter(S3BucketConfiguration.getter(S3BucketConfiguration::bucketPrefix)).setter(S3BucketConfiguration.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketPrefix").build()}).build();
    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketRegion").getter(S3BucketConfiguration.getter(S3BucketConfiguration::bucketRegion)).setter(S3BucketConfiguration.setter(Builder::bucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, BUCKET_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3BucketConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String bucketPrefix;
    private final String bucketRegion;

    private S3BucketConfiguration(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.bucketRegion = builder.bucketRegion;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketPrefix() {
        return this.bucketPrefix;
    }

    public final String bucketRegion() {
        return this.bucketRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketConfiguration)) {
            return false;
        }
        S3BucketConfiguration other = (S3BucketConfiguration)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix()) && Objects.equals(this.bucketRegion(), other.bucketRegion());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketConfiguration").add("BucketName", (Object)this.bucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).add("BucketRegion", (Object)this.bucketRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "BucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
            case "BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.bucketRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("BucketPrefix", BUCKET_PREFIX_FIELD);
        map.put("BucketRegion", BUCKET_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BucketConfiguration, T> g) {
        return obj -> g.apply((S3BucketConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String bucketPrefix;
        private String bucketRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketConfiguration model) {
            this.bucketName(model.bucketName);
            this.bucketPrefix(model.bucketPrefix);
            this.bucketRegion(model.bucketRegion);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getBucketRegion() {
            return this.bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public S3BucketConfiguration build() {
            return new S3BucketConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketConfiguration> {
        public Builder bucketName(String var1);

        public Builder bucketPrefix(String var1);

        public Builder bucketRegion(String var1);
    }
}

