/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.CustomSql;
import software.amazon.awssdk.services.quicksight.model.RelationalTable;
import software.amazon.awssdk.services.quicksight.model.S3Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalTable> {
    private static final SdkField<RelationalTable> RELATIONAL_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelationalTable").getter(PhysicalTable.getter(PhysicalTable::relationalTable)).setter(PhysicalTable.setter(Builder::relationalTable)).constructor(RelationalTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationalTable").build()}).build();
    private static final SdkField<CustomSql> CUSTOM_SQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomSql").getter(PhysicalTable.getter(PhysicalTable::customSql)).setter(PhysicalTable.setter(Builder::customSql)).constructor(CustomSql::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSql").build()}).build();
    private static final SdkField<S3Source> S3_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Source").getter(PhysicalTable.getter(PhysicalTable::s3Source)).setter(PhysicalTable.setter(Builder::s3Source)).constructor(S3Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_TABLE_FIELD, CUSTOM_SQL_FIELD, S3_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhysicalTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RelationalTable relationalTable;
    private final CustomSql customSql;
    private final S3Source s3Source;
    private final Type type;

    private PhysicalTable(BuilderImpl builder) {
        this.relationalTable = builder.relationalTable;
        this.customSql = builder.customSql;
        this.s3Source = builder.s3Source;
        this.type = builder.type;
    }

    public final RelationalTable relationalTable() {
        return this.relationalTable;
    }

    public final CustomSql customSql() {
        return this.customSql;
    }

    public final S3Source s3Source() {
        return this.s3Source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSql());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalTable)) {
            return false;
        }
        PhysicalTable other = (PhysicalTable)obj;
        return Objects.equals(this.relationalTable(), other.relationalTable()) && Objects.equals(this.customSql(), other.customSql()) && Objects.equals(this.s3Source(), other.s3Source());
    }

    public final String toString() {
        return ToString.builder((String)"PhysicalTable").add("RelationalTable", (Object)this.relationalTable()).add("CustomSql", (Object)this.customSql()).add("S3Source", (Object)this.s3Source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RelationalTable": {
                return Optional.ofNullable(clazz.cast(this.relationalTable()));
            }
            case "CustomSql": {
                return Optional.ofNullable(clazz.cast(this.customSql()));
            }
            case "S3Source": {
                return Optional.ofNullable(clazz.cast(this.s3Source()));
            }
        }
        return Optional.empty();
    }

    public static PhysicalTable fromRelationalTable(RelationalTable relationalTable) {
        return (PhysicalTable)PhysicalTable.builder().relationalTable(relationalTable).build();
    }

    public static PhysicalTable fromRelationalTable(Consumer<RelationalTable.Builder> relationalTable) {
        RelationalTable.Builder builder = RelationalTable.builder();
        relationalTable.accept(builder);
        return PhysicalTable.fromRelationalTable((RelationalTable)builder.build());
    }

    public static PhysicalTable fromCustomSql(CustomSql customSql) {
        return (PhysicalTable)PhysicalTable.builder().customSql(customSql).build();
    }

    public static PhysicalTable fromCustomSql(Consumer<CustomSql.Builder> customSql) {
        CustomSql.Builder builder = CustomSql.builder();
        customSql.accept(builder);
        return PhysicalTable.fromCustomSql((CustomSql)builder.build());
    }

    public static PhysicalTable fromS3Source(S3Source s3Source) {
        return (PhysicalTable)PhysicalTable.builder().s3Source(s3Source).build();
    }

    public static PhysicalTable fromS3Source(Consumer<S3Source.Builder> s3Source) {
        S3Source.Builder builder = S3Source.builder();
        s3Source.accept(builder);
        return PhysicalTable.fromS3Source((S3Source)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RelationalTable", RELATIONAL_TABLE_FIELD);
        map.put("CustomSql", CUSTOM_SQL_FIELD);
        map.put("S3Source", S3_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalTable, T> g) {
        return obj -> g.apply((PhysicalTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RELATIONAL_TABLE,
        CUSTOM_SQL,
        S3_SOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RelationalTable relationalTable;
        private CustomSql customSql;
        private S3Source s3Source;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalTable model) {
            this.relationalTable(model.relationalTable);
            this.customSql(model.customSql);
            this.s3Source(model.s3Source);
        }

        public final RelationalTable.Builder getRelationalTable() {
            return this.relationalTable != null ? this.relationalTable.toBuilder() : null;
        }

        public final void setRelationalTable(RelationalTable.BuilderImpl relationalTable) {
            RelationalTable oldValue = this.relationalTable;
            this.relationalTable = relationalTable != null ? relationalTable.build() : null;
            this.handleUnionValueChange(Type.RELATIONAL_TABLE, oldValue, this.relationalTable);
        }

        @Override
        public final Builder relationalTable(RelationalTable relationalTable) {
            RelationalTable oldValue = this.relationalTable;
            this.relationalTable = relationalTable;
            this.handleUnionValueChange(Type.RELATIONAL_TABLE, oldValue, this.relationalTable);
            return this;
        }

        public final CustomSql.Builder getCustomSql() {
            return this.customSql != null ? this.customSql.toBuilder() : null;
        }

        public final void setCustomSql(CustomSql.BuilderImpl customSql) {
            CustomSql oldValue = this.customSql;
            this.customSql = customSql != null ? customSql.build() : null;
            this.handleUnionValueChange(Type.CUSTOM_SQL, oldValue, this.customSql);
        }

        @Override
        public final Builder customSql(CustomSql customSql) {
            CustomSql oldValue = this.customSql;
            this.customSql = customSql;
            this.handleUnionValueChange(Type.CUSTOM_SQL, oldValue, this.customSql);
            return this;
        }

        public final S3Source.Builder getS3Source() {
            return this.s3Source != null ? this.s3Source.toBuilder() : null;
        }

        public final void setS3Source(S3Source.BuilderImpl s3Source) {
            S3Source oldValue = this.s3Source;
            this.s3Source = s3Source != null ? s3Source.build() : null;
            this.handleUnionValueChange(Type.S3_SOURCE, oldValue, this.s3Source);
        }

        @Override
        public final Builder s3Source(S3Source s3Source) {
            S3Source oldValue = this.s3Source;
            this.s3Source = s3Source;
            this.handleUnionValueChange(Type.S3_SOURCE, oldValue, this.s3Source);
            return this;
        }

        public PhysicalTable build() {
            return new PhysicalTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalTable> {
        public Builder relationalTable(RelationalTable var1);

        default public Builder relationalTable(Consumer<RelationalTable.Builder> relationalTable) {
            return this.relationalTable((RelationalTable)((RelationalTable.Builder)RelationalTable.builder().applyMutation(relationalTable)).build());
        }

        public Builder customSql(CustomSql var1);

        default public Builder customSql(Consumer<CustomSql.Builder> customSql) {
            return this.customSql((CustomSql)((CustomSql.Builder)CustomSql.builder().applyMutation(customSql)).build());
        }

        public Builder s3Source(S3Source var1);

        default public Builder s3Source(Consumer<S3Source.Builder> s3Source) {
            return this.s3Source((S3Source)((S3Source.Builder)S3Source.builder().applyMutation(s3Source)).build());
        }
    }
}

