/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CustomPermissions;
import software.amazon.awssdk.services.quicksight.model.CustomPermissionsListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomPermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListCustomPermissionsResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListCustomPermissionsResponse.getter(ListCustomPermissionsResponse::status)).setter(ListCustomPermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<List<CustomPermissions>> CUSTOM_PERMISSIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomPermissionsList").getter(ListCustomPermissionsResponse.getter(ListCustomPermissionsResponse::customPermissionsList)).setter(ListCustomPermissionsResponse.setter(Builder::customPermissionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomPermissionsResponse.getter(ListCustomPermissionsResponse::nextToken)).setter(ListCustomPermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListCustomPermissionsResponse.getter(ListCustomPermissionsResponse::requestId)).setter(ListCustomPermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CUSTOM_PERMISSIONS_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCustomPermissionsResponse.memberNameToFieldInitializer();
    private final Integer status;
    private final List<CustomPermissions> customPermissionsList;
    private final String nextToken;
    private final String requestId;

    private ListCustomPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.customPermissionsList = builder.customPermissionsList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final boolean hasCustomPermissionsList() {
        return this.customPermissionsList != null && !(this.customPermissionsList instanceof SdkAutoConstructList);
    }

    public final List<CustomPermissions> customPermissionsList() {
        return this.customPermissionsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomPermissionsList() ? this.customPermissionsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomPermissionsResponse)) {
            return false;
        }
        ListCustomPermissionsResponse other = (ListCustomPermissionsResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && this.hasCustomPermissionsList() == other.hasCustomPermissionsList() && Objects.equals(this.customPermissionsList(), other.customPermissionsList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomPermissionsResponse").add("Status", (Object)this.status()).add("CustomPermissionsList", this.hasCustomPermissionsList() ? this.customPermissionsList() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CustomPermissionsList": {
                return Optional.ofNullable(clazz.cast(this.customPermissionsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("CustomPermissionsList", CUSTOM_PERMISSIONS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomPermissionsResponse, T> g) {
        return obj -> g.apply((ListCustomPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private List<CustomPermissions> customPermissionsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomPermissionsResponse model) {
            super(model);
            this.status(model.status);
            this.customPermissionsList(model.customPermissionsList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final List<CustomPermissions.Builder> getCustomPermissionsList() {
            List<CustomPermissions.Builder> result = CustomPermissionsListCopier.copyToBuilder(this.customPermissionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomPermissionsList(Collection<CustomPermissions.BuilderImpl> customPermissionsList) {
            this.customPermissionsList = CustomPermissionsListCopier.copyFromBuilder(customPermissionsList);
        }

        @Override
        public final Builder customPermissionsList(Collection<CustomPermissions> customPermissionsList) {
            this.customPermissionsList = CustomPermissionsListCopier.copy(customPermissionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customPermissionsList(CustomPermissions ... customPermissionsList) {
            this.customPermissionsList(Arrays.asList(customPermissionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customPermissionsList(Consumer<CustomPermissions.Builder> ... customPermissionsList) {
            this.customPermissionsList(Stream.of(customPermissionsList).map(c -> (CustomPermissions)((CustomPermissions.Builder)CustomPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListCustomPermissionsResponse build() {
            return new ListCustomPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomPermissionsResponse> {
        public Builder status(Integer var1);

        public Builder customPermissionsList(Collection<CustomPermissions> var1);

        public Builder customPermissionsList(CustomPermissions ... var1);

        public Builder customPermissionsList(Consumer<CustomPermissions.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);
    }
}

