/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.QldbRequest;
import software.amazon.awssdk.services.qldb.model.ValueHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRevisionRequest
extends QldbRequest
implements ToCopyableBuilder<Builder, GetRevisionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetRevisionRequest.getter(GetRevisionRequest::name)).setter(GetRevisionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<ValueHolder> BLOCK_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlockAddress").getter(GetRevisionRequest.getter(GetRevisionRequest::blockAddress)).setter(GetRevisionRequest.setter(Builder::blockAddress)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockAddress").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(GetRevisionRequest.getter(GetRevisionRequest::documentId)).setter(GetRevisionRequest.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<ValueHolder> DIGEST_TIP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DigestTipAddress").getter(GetRevisionRequest.getter(GetRevisionRequest::digestTipAddress)).setter(GetRevisionRequest.setter(Builder::digestTipAddress)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestTipAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BLOCK_ADDRESS_FIELD, DOCUMENT_ID_FIELD, DIGEST_TIP_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRevisionRequest.memberNameToFieldInitializer();
    private final String name;
    private final ValueHolder blockAddress;
    private final String documentId;
    private final ValueHolder digestTipAddress;

    private GetRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.blockAddress = builder.blockAddress;
        this.documentId = builder.documentId;
        this.digestTipAddress = builder.digestTipAddress;
    }

    public final String name() {
        return this.name;
    }

    public final ValueHolder blockAddress() {
        return this.blockAddress;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final ValueHolder digestTipAddress() {
        return this.digestTipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.digestTipAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevisionRequest)) {
            return false;
        }
        GetRevisionRequest other = (GetRevisionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.blockAddress(), other.blockAddress()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.digestTipAddress(), other.digestTipAddress());
    }

    public final String toString() {
        return ToString.builder((String)"GetRevisionRequest").add("Name", (Object)this.name()).add("BlockAddress", (Object)(this.blockAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DocumentId", (Object)this.documentId()).add("DigestTipAddress", (Object)(this.digestTipAddress() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BlockAddress": {
                return Optional.ofNullable(clazz.cast(this.blockAddress()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DigestTipAddress": {
                return Optional.ofNullable(clazz.cast(this.digestTipAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("BlockAddress", BLOCK_ADDRESS_FIELD);
        map.put("DocumentId", DOCUMENT_ID_FIELD);
        map.put("DigestTipAddress", DIGEST_TIP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRevisionRequest, T> g) {
        return obj -> g.apply((GetRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbRequest.BuilderImpl
    implements Builder {
        private String name;
        private ValueHolder blockAddress;
        private String documentId;
        private ValueHolder digestTipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRevisionRequest model) {
            super(model);
            this.name(model.name);
            this.blockAddress(model.blockAddress);
            this.documentId(model.documentId);
            this.digestTipAddress(model.digestTipAddress);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ValueHolder.Builder getBlockAddress() {
            return this.blockAddress != null ? this.blockAddress.toBuilder() : null;
        }

        public final void setBlockAddress(ValueHolder.BuilderImpl blockAddress) {
            this.blockAddress = blockAddress != null ? blockAddress.build() : null;
        }

        @Override
        public final Builder blockAddress(ValueHolder blockAddress) {
            this.blockAddress = blockAddress;
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final ValueHolder.Builder getDigestTipAddress() {
            return this.digestTipAddress != null ? this.digestTipAddress.toBuilder() : null;
        }

        public final void setDigestTipAddress(ValueHolder.BuilderImpl digestTipAddress) {
            this.digestTipAddress = digestTipAddress != null ? digestTipAddress.build() : null;
        }

        @Override
        public final Builder digestTipAddress(ValueHolder digestTipAddress) {
            this.digestTipAddress = digestTipAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRevisionRequest build() {
            return new GetRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QldbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRevisionRequest> {
        public Builder name(String var1);

        public Builder blockAddress(ValueHolder var1);

        default public Builder blockAddress(Consumer<ValueHolder.Builder> blockAddress) {
            return this.blockAddress((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(blockAddress)).build());
        }

        public Builder documentId(String var1);

        public Builder digestTipAddress(ValueHolder var1);

        default public Builder digestTipAddress(Consumer<ValueHolder.Builder> digestTipAddress) {
            return this.digestTipAddress((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(digestTipAddress)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

