/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpanType {
    CLIENT("CLIENT"),
    SERVER("SERVER"),
    INTERNAL("INTERNAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpanType> VALUE_MAP;
    private final String value;

    private SpanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpanType> knownValues() {
        EnumSet<SpanType> knownValues = EnumSet.allOf(SpanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpanType.class, SpanType::toString);
    }
}

