/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.SpanTextValue;
import software.amazon.awssdk.services.qconnect.model.SpanToolResultValue;
import software.amazon.awssdk.services.qconnect.model.SpanToolUseValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpanMessageValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpanMessageValue> {
    private static final SdkField<SpanTextValue> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("text").getter(SpanMessageValue.getter(SpanMessageValue::text)).setter(SpanMessageValue.setter(Builder::text)).constructor(SpanTextValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<SpanToolUseValue> TOOL_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolUse").getter(SpanMessageValue.getter(SpanMessageValue::toolUse)).setter(SpanMessageValue.setter(Builder::toolUse)).constructor(SpanToolUseValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()}).build();
    private static final SdkField<SpanToolResultValue> TOOL_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolResult").getter(SpanMessageValue.getter(SpanMessageValue::toolResult)).setter(SpanMessageValue.setter(Builder::toolResult)).constructor(SpanToolResultValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TOOL_USE_FIELD, TOOL_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpanMessageValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SpanTextValue text;
    private final SpanToolUseValue toolUse;
    private final SpanToolResultValue toolResult;
    private final Type type;

    private SpanMessageValue(BuilderImpl builder) {
        this.text = builder.text;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.type = builder.type;
    }

    public final SpanTextValue text() {
        return this.text;
    }

    public final SpanToolUseValue toolUse() {
        return this.toolUse;
    }

    public final SpanToolResultValue toolResult() {
        return this.toolResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanMessageValue)) {
            return false;
        }
        SpanMessageValue other = (SpanMessageValue)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.toolUse(), other.toolUse()) && Objects.equals(this.toolResult(), other.toolResult());
    }

    public final String toString() {
        return ToString.builder((String)"SpanMessageValue").add("Text", (Object)this.text()).add("ToolUse", (Object)this.toolUse()).add("ToolResult", (Object)this.toolResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "toolUse": {
                return Optional.ofNullable(clazz.cast(this.toolUse()));
            }
            case "toolResult": {
                return Optional.ofNullable(clazz.cast(this.toolResult()));
            }
        }
        return Optional.empty();
    }

    public static SpanMessageValue fromText(SpanTextValue text) {
        return (SpanMessageValue)SpanMessageValue.builder().text(text).build();
    }

    public static SpanMessageValue fromText(Consumer<SpanTextValue.Builder> text) {
        SpanTextValue.Builder builder = SpanTextValue.builder();
        text.accept(builder);
        return SpanMessageValue.fromText((SpanTextValue)builder.build());
    }

    public static SpanMessageValue fromToolUse(SpanToolUseValue toolUse) {
        return (SpanMessageValue)SpanMessageValue.builder().toolUse(toolUse).build();
    }

    public static SpanMessageValue fromToolUse(Consumer<SpanToolUseValue.Builder> toolUse) {
        SpanToolUseValue.Builder builder = SpanToolUseValue.builder();
        toolUse.accept(builder);
        return SpanMessageValue.fromToolUse((SpanToolUseValue)builder.build());
    }

    public static SpanMessageValue fromToolResult(SpanToolResultValue toolResult) {
        return (SpanMessageValue)SpanMessageValue.builder().toolResult(toolResult).build();
    }

    public static SpanMessageValue fromToolResult(Consumer<SpanToolResultValue.Builder> toolResult) {
        SpanToolResultValue.Builder builder = SpanToolResultValue.builder();
        toolResult.accept(builder);
        return SpanMessageValue.fromToolResult((SpanToolResultValue)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanMessageValue, T> g) {
        return obj -> g.apply((SpanMessageValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        TOOL_USE,
        TOOL_RESULT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SpanTextValue text;
        private SpanToolUseValue toolUse;
        private SpanToolResultValue toolResult;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SpanMessageValue model) {
            this.text(model.text);
            this.toolUse(model.toolUse);
            this.toolResult(model.toolResult);
        }

        public final SpanTextValue.Builder getText() {
            return this.text != null ? this.text.toBuilder() : null;
        }

        public final void setText(SpanTextValue.BuilderImpl text) {
            SpanTextValue oldValue = this.text;
            this.text = text != null ? text.build() : null;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(SpanTextValue text) {
            SpanTextValue oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final SpanToolUseValue.Builder getToolUse() {
            return this.toolUse != null ? this.toolUse.toBuilder() : null;
        }

        public final void setToolUse(SpanToolUseValue.BuilderImpl toolUse) {
            SpanToolUseValue oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(SpanToolUseValue toolUse) {
            SpanToolUseValue oldValue = this.toolUse;
            this.toolUse = toolUse;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final SpanToolResultValue.Builder getToolResult() {
            return this.toolResult != null ? this.toolResult.toBuilder() : null;
        }

        public final void setToolResult(SpanToolResultValue.BuilderImpl toolResult) {
            SpanToolResultValue oldValue = this.toolResult;
            this.toolResult = toolResult != null ? toolResult.build() : null;
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(SpanToolResultValue toolResult) {
            SpanToolResultValue oldValue = this.toolResult;
            this.toolResult = toolResult;
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        public SpanMessageValue build() {
            return new SpanMessageValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpanMessageValue> {
        public Builder text(SpanTextValue var1);

        default public Builder text(Consumer<SpanTextValue.Builder> text) {
            return this.text((SpanTextValue)((SpanTextValue.Builder)SpanTextValue.builder().applyMutation(text)).build());
        }

        public Builder toolUse(SpanToolUseValue var1);

        default public Builder toolUse(Consumer<SpanToolUseValue.Builder> toolUse) {
            return this.toolUse((SpanToolUseValue)((SpanToolUseValue.Builder)SpanToolUseValue.builder().applyMutation(toolUse)).build());
        }

        public Builder toolResult(SpanToolResultValue var1);

        default public Builder toolResult(Consumer<SpanToolResultValue.Builder> toolResult) {
            return this.toolResult((SpanToolResultValue)((SpanToolResultValue.Builder)SpanToolResultValue.builder().applyMutation(toolResult)).build());
        }
    }
}

