/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceContentType {
    KNOWLEDGE_CONTENT("KNOWLEDGE_CONTENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceContentType> VALUE_MAP;
    private final String value;

    private SourceContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceContentType> knownValues() {
        EnumSet<SourceContentType> knownValues = EnumSet.allOf(SourceContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceContentType.class, SourceContentType::toString);
    }
}

