/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageFilterType {
    ALL("ALL"),
    TEXT_ONLY("TEXT_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageFilterType> VALUE_MAP;
    private final String value;

    private MessageFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageFilterType> knownValues() {
        EnumSet<MessageFilterType> knownValues = EnumSet.allOf(MessageFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageFilterType.class, MessageFilterType::toString);
    }
}

