/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.CaseSummarizationChunkDataDetails;
import software.amazon.awssdk.services.qconnect.model.ContentDataDetails;
import software.amazon.awssdk.services.qconnect.model.EmailGenerativeAnswerChunkDataDetails;
import software.amazon.awssdk.services.qconnect.model.EmailOverviewChunkDataDetails;
import software.amazon.awssdk.services.qconnect.model.EmailResponseChunkDataDetails;
import software.amazon.awssdk.services.qconnect.model.GenerativeChunkDataDetails;
import software.amazon.awssdk.services.qconnect.model.GenerativeDataDetails;
import software.amazon.awssdk.services.qconnect.model.IntentDetectedDataDetails;
import software.amazon.awssdk.services.qconnect.model.NotesChunkDataDetails;
import software.amazon.awssdk.services.qconnect.model.NotesDataDetails;
import software.amazon.awssdk.services.qconnect.model.SourceContentDataDetails;
import software.amazon.awssdk.services.qconnect.model.SuggestedMessageDataDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataDetails> {
    private static final SdkField<ContentDataDetails> CONTENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentData").getter(DataDetails.getter(DataDetails::contentData)).setter(DataDetails.setter(Builder::contentData)).constructor(ContentDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentData").build()}).build();
    private static final SdkField<GenerativeDataDetails> GENERATIVE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeData").getter(DataDetails.getter(DataDetails::generativeData)).setter(DataDetails.setter(Builder::generativeData)).constructor(GenerativeDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeData").build()}).build();
    private static final SdkField<IntentDetectedDataDetails> INTENT_DETECTED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intentDetectedData").getter(DataDetails.getter(DataDetails::intentDetectedData)).setter(DataDetails.setter(Builder::intentDetectedData)).constructor(IntentDetectedDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentDetectedData").build()}).build();
    private static final SdkField<SourceContentDataDetails> SOURCE_CONTENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceContentData").getter(DataDetails.getter(DataDetails::sourceContentData)).setter(DataDetails.setter(Builder::sourceContentData)).constructor(SourceContentDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContentData").build()}).build();
    private static final SdkField<GenerativeChunkDataDetails> GENERATIVE_CHUNK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeChunkData").getter(DataDetails.getter(DataDetails::generativeChunkData)).setter(DataDetails.setter(Builder::generativeChunkData)).constructor(GenerativeChunkDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeChunkData").build()}).build();
    private static final SdkField<EmailResponseChunkDataDetails> EMAIL_RESPONSE_CHUNK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("emailResponseChunkData").getter(DataDetails.getter(DataDetails::emailResponseChunkData)).setter(DataDetails.setter(Builder::emailResponseChunkData)).constructor(EmailResponseChunkDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailResponseChunkData").build()}).build();
    private static final SdkField<EmailOverviewChunkDataDetails> EMAIL_OVERVIEW_CHUNK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("emailOverviewChunkData").getter(DataDetails.getter(DataDetails::emailOverviewChunkData)).setter(DataDetails.setter(Builder::emailOverviewChunkData)).constructor(EmailOverviewChunkDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailOverviewChunkData").build()}).build();
    private static final SdkField<EmailGenerativeAnswerChunkDataDetails> EMAIL_GENERATIVE_ANSWER_CHUNK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("emailGenerativeAnswerChunkData").getter(DataDetails.getter(DataDetails::emailGenerativeAnswerChunkData)).setter(DataDetails.setter(Builder::emailGenerativeAnswerChunkData)).constructor(EmailGenerativeAnswerChunkDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailGenerativeAnswerChunkData").build()}).build();
    private static final SdkField<CaseSummarizationChunkDataDetails> CASE_SUMMARIZATION_CHUNK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("caseSummarizationChunkData").getter(DataDetails.getter(DataDetails::caseSummarizationChunkData)).setter(DataDetails.setter(Builder::caseSummarizationChunkData)).constructor(CaseSummarizationChunkDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseSummarizationChunkData").build()}).build();
    private static final SdkField<SuggestedMessageDataDetails> SUGGESTED_MESSAGE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suggestedMessageData").getter(DataDetails.getter(DataDetails::suggestedMessageData)).setter(DataDetails.setter(Builder::suggestedMessageData)).constructor(SuggestedMessageDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedMessageData").build()}).build();
    private static final SdkField<NotesDataDetails> NOTES_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notesData").getter(DataDetails.getter(DataDetails::notesData)).setter(DataDetails.setter(Builder::notesData)).constructor(NotesDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notesData").build()}).build();
    private static final SdkField<NotesChunkDataDetails> NOTES_CHUNK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notesChunkData").getter(DataDetails.getter(DataDetails::notesChunkData)).setter(DataDetails.setter(Builder::notesChunkData)).constructor(NotesChunkDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notesChunkData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_DATA_FIELD, GENERATIVE_DATA_FIELD, INTENT_DETECTED_DATA_FIELD, SOURCE_CONTENT_DATA_FIELD, GENERATIVE_CHUNK_DATA_FIELD, EMAIL_RESPONSE_CHUNK_DATA_FIELD, EMAIL_OVERVIEW_CHUNK_DATA_FIELD, EMAIL_GENERATIVE_ANSWER_CHUNK_DATA_FIELD, CASE_SUMMARIZATION_CHUNK_DATA_FIELD, SUGGESTED_MESSAGE_DATA_FIELD, NOTES_DATA_FIELD, NOTES_CHUNK_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContentDataDetails contentData;
    private final GenerativeDataDetails generativeData;
    private final IntentDetectedDataDetails intentDetectedData;
    private final SourceContentDataDetails sourceContentData;
    private final GenerativeChunkDataDetails generativeChunkData;
    private final EmailResponseChunkDataDetails emailResponseChunkData;
    private final EmailOverviewChunkDataDetails emailOverviewChunkData;
    private final EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData;
    private final CaseSummarizationChunkDataDetails caseSummarizationChunkData;
    private final SuggestedMessageDataDetails suggestedMessageData;
    private final NotesDataDetails notesData;
    private final NotesChunkDataDetails notesChunkData;
    private final Type type;

    private DataDetails(BuilderImpl builder) {
        this.contentData = builder.contentData;
        this.generativeData = builder.generativeData;
        this.intentDetectedData = builder.intentDetectedData;
        this.sourceContentData = builder.sourceContentData;
        this.generativeChunkData = builder.generativeChunkData;
        this.emailResponseChunkData = builder.emailResponseChunkData;
        this.emailOverviewChunkData = builder.emailOverviewChunkData;
        this.emailGenerativeAnswerChunkData = builder.emailGenerativeAnswerChunkData;
        this.caseSummarizationChunkData = builder.caseSummarizationChunkData;
        this.suggestedMessageData = builder.suggestedMessageData;
        this.notesData = builder.notesData;
        this.notesChunkData = builder.notesChunkData;
        this.type = builder.type;
    }

    public final ContentDataDetails contentData() {
        return this.contentData;
    }

    public final GenerativeDataDetails generativeData() {
        return this.generativeData;
    }

    public final IntentDetectedDataDetails intentDetectedData() {
        return this.intentDetectedData;
    }

    public final SourceContentDataDetails sourceContentData() {
        return this.sourceContentData;
    }

    public final GenerativeChunkDataDetails generativeChunkData() {
        return this.generativeChunkData;
    }

    public final EmailResponseChunkDataDetails emailResponseChunkData() {
        return this.emailResponseChunkData;
    }

    public final EmailOverviewChunkDataDetails emailOverviewChunkData() {
        return this.emailOverviewChunkData;
    }

    public final EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData() {
        return this.emailGenerativeAnswerChunkData;
    }

    public final CaseSummarizationChunkDataDetails caseSummarizationChunkData() {
        return this.caseSummarizationChunkData;
    }

    public final SuggestedMessageDataDetails suggestedMessageData() {
        return this.suggestedMessageData;
    }

    public final NotesDataDetails notesData() {
        return this.notesData;
    }

    public final NotesChunkDataDetails notesChunkData() {
        return this.notesChunkData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentData());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeData());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentDetectedData());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceContentData());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailResponseChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailOverviewChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailGenerativeAnswerChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseSummarizationChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestedMessageData());
        hashCode = 31 * hashCode + Objects.hashCode(this.notesData());
        hashCode = 31 * hashCode + Objects.hashCode(this.notesChunkData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDetails)) {
            return false;
        }
        DataDetails other = (DataDetails)obj;
        return Objects.equals(this.contentData(), other.contentData()) && Objects.equals(this.generativeData(), other.generativeData()) && Objects.equals(this.intentDetectedData(), other.intentDetectedData()) && Objects.equals(this.sourceContentData(), other.sourceContentData()) && Objects.equals(this.generativeChunkData(), other.generativeChunkData()) && Objects.equals(this.emailResponseChunkData(), other.emailResponseChunkData()) && Objects.equals(this.emailOverviewChunkData(), other.emailOverviewChunkData()) && Objects.equals(this.emailGenerativeAnswerChunkData(), other.emailGenerativeAnswerChunkData()) && Objects.equals(this.caseSummarizationChunkData(), other.caseSummarizationChunkData()) && Objects.equals(this.suggestedMessageData(), other.suggestedMessageData()) && Objects.equals(this.notesData(), other.notesData()) && Objects.equals(this.notesChunkData(), other.notesChunkData());
    }

    public final String toString() {
        return ToString.builder((String)"DataDetails").add("ContentData", (Object)this.contentData()).add("GenerativeData", (Object)this.generativeData()).add("IntentDetectedData", (Object)this.intentDetectedData()).add("SourceContentData", (Object)this.sourceContentData()).add("GenerativeChunkData", (Object)this.generativeChunkData()).add("EmailResponseChunkData", (Object)this.emailResponseChunkData()).add("EmailOverviewChunkData", (Object)this.emailOverviewChunkData()).add("EmailGenerativeAnswerChunkData", (Object)this.emailGenerativeAnswerChunkData()).add("CaseSummarizationChunkData", (Object)this.caseSummarizationChunkData()).add("SuggestedMessageData", (Object)this.suggestedMessageData()).add("NotesData", (Object)this.notesData()).add("NotesChunkData", (Object)this.notesChunkData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentData": {
                return Optional.ofNullable(clazz.cast(this.contentData()));
            }
            case "generativeData": {
                return Optional.ofNullable(clazz.cast(this.generativeData()));
            }
            case "intentDetectedData": {
                return Optional.ofNullable(clazz.cast(this.intentDetectedData()));
            }
            case "sourceContentData": {
                return Optional.ofNullable(clazz.cast(this.sourceContentData()));
            }
            case "generativeChunkData": {
                return Optional.ofNullable(clazz.cast(this.generativeChunkData()));
            }
            case "emailResponseChunkData": {
                return Optional.ofNullable(clazz.cast(this.emailResponseChunkData()));
            }
            case "emailOverviewChunkData": {
                return Optional.ofNullable(clazz.cast(this.emailOverviewChunkData()));
            }
            case "emailGenerativeAnswerChunkData": {
                return Optional.ofNullable(clazz.cast(this.emailGenerativeAnswerChunkData()));
            }
            case "caseSummarizationChunkData": {
                return Optional.ofNullable(clazz.cast(this.caseSummarizationChunkData()));
            }
            case "suggestedMessageData": {
                return Optional.ofNullable(clazz.cast(this.suggestedMessageData()));
            }
            case "notesData": {
                return Optional.ofNullable(clazz.cast(this.notesData()));
            }
            case "notesChunkData": {
                return Optional.ofNullable(clazz.cast(this.notesChunkData()));
            }
        }
        return Optional.empty();
    }

    public static DataDetails fromContentData(ContentDataDetails contentData) {
        return (DataDetails)DataDetails.builder().contentData(contentData).build();
    }

    public static DataDetails fromContentData(Consumer<ContentDataDetails.Builder> contentData) {
        ContentDataDetails.Builder builder = ContentDataDetails.builder();
        contentData.accept(builder);
        return DataDetails.fromContentData((ContentDataDetails)builder.build());
    }

    public static DataDetails fromGenerativeData(GenerativeDataDetails generativeData) {
        return (DataDetails)DataDetails.builder().generativeData(generativeData).build();
    }

    public static DataDetails fromGenerativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
        GenerativeDataDetails.Builder builder = GenerativeDataDetails.builder();
        generativeData.accept(builder);
        return DataDetails.fromGenerativeData((GenerativeDataDetails)builder.build());
    }

    public static DataDetails fromIntentDetectedData(IntentDetectedDataDetails intentDetectedData) {
        return (DataDetails)DataDetails.builder().intentDetectedData(intentDetectedData).build();
    }

    public static DataDetails fromIntentDetectedData(Consumer<IntentDetectedDataDetails.Builder> intentDetectedData) {
        IntentDetectedDataDetails.Builder builder = IntentDetectedDataDetails.builder();
        intentDetectedData.accept(builder);
        return DataDetails.fromIntentDetectedData((IntentDetectedDataDetails)builder.build());
    }

    public static DataDetails fromSourceContentData(SourceContentDataDetails sourceContentData) {
        return (DataDetails)DataDetails.builder().sourceContentData(sourceContentData).build();
    }

    public static DataDetails fromSourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
        SourceContentDataDetails.Builder builder = SourceContentDataDetails.builder();
        sourceContentData.accept(builder);
        return DataDetails.fromSourceContentData((SourceContentDataDetails)builder.build());
    }

    public static DataDetails fromGenerativeChunkData(GenerativeChunkDataDetails generativeChunkData) {
        return (DataDetails)DataDetails.builder().generativeChunkData(generativeChunkData).build();
    }

    public static DataDetails fromGenerativeChunkData(Consumer<GenerativeChunkDataDetails.Builder> generativeChunkData) {
        GenerativeChunkDataDetails.Builder builder = GenerativeChunkDataDetails.builder();
        generativeChunkData.accept(builder);
        return DataDetails.fromGenerativeChunkData((GenerativeChunkDataDetails)builder.build());
    }

    public static DataDetails fromEmailResponseChunkData(EmailResponseChunkDataDetails emailResponseChunkData) {
        return (DataDetails)DataDetails.builder().emailResponseChunkData(emailResponseChunkData).build();
    }

    public static DataDetails fromEmailResponseChunkData(Consumer<EmailResponseChunkDataDetails.Builder> emailResponseChunkData) {
        EmailResponseChunkDataDetails.Builder builder = EmailResponseChunkDataDetails.builder();
        emailResponseChunkData.accept(builder);
        return DataDetails.fromEmailResponseChunkData((EmailResponseChunkDataDetails)builder.build());
    }

    public static DataDetails fromEmailOverviewChunkData(EmailOverviewChunkDataDetails emailOverviewChunkData) {
        return (DataDetails)DataDetails.builder().emailOverviewChunkData(emailOverviewChunkData).build();
    }

    public static DataDetails fromEmailOverviewChunkData(Consumer<EmailOverviewChunkDataDetails.Builder> emailOverviewChunkData) {
        EmailOverviewChunkDataDetails.Builder builder = EmailOverviewChunkDataDetails.builder();
        emailOverviewChunkData.accept(builder);
        return DataDetails.fromEmailOverviewChunkData((EmailOverviewChunkDataDetails)builder.build());
    }

    public static DataDetails fromEmailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData) {
        return (DataDetails)DataDetails.builder().emailGenerativeAnswerChunkData(emailGenerativeAnswerChunkData).build();
    }

    public static DataDetails fromEmailGenerativeAnswerChunkData(Consumer<EmailGenerativeAnswerChunkDataDetails.Builder> emailGenerativeAnswerChunkData) {
        EmailGenerativeAnswerChunkDataDetails.Builder builder = EmailGenerativeAnswerChunkDataDetails.builder();
        emailGenerativeAnswerChunkData.accept(builder);
        return DataDetails.fromEmailGenerativeAnswerChunkData((EmailGenerativeAnswerChunkDataDetails)builder.build());
    }

    public static DataDetails fromCaseSummarizationChunkData(CaseSummarizationChunkDataDetails caseSummarizationChunkData) {
        return (DataDetails)DataDetails.builder().caseSummarizationChunkData(caseSummarizationChunkData).build();
    }

    public static DataDetails fromCaseSummarizationChunkData(Consumer<CaseSummarizationChunkDataDetails.Builder> caseSummarizationChunkData) {
        CaseSummarizationChunkDataDetails.Builder builder = CaseSummarizationChunkDataDetails.builder();
        caseSummarizationChunkData.accept(builder);
        return DataDetails.fromCaseSummarizationChunkData((CaseSummarizationChunkDataDetails)builder.build());
    }

    public static DataDetails fromSuggestedMessageData(SuggestedMessageDataDetails suggestedMessageData) {
        return (DataDetails)DataDetails.builder().suggestedMessageData(suggestedMessageData).build();
    }

    public static DataDetails fromSuggestedMessageData(Consumer<SuggestedMessageDataDetails.Builder> suggestedMessageData) {
        SuggestedMessageDataDetails.Builder builder = SuggestedMessageDataDetails.builder();
        suggestedMessageData.accept(builder);
        return DataDetails.fromSuggestedMessageData((SuggestedMessageDataDetails)builder.build());
    }

    public static DataDetails fromNotesData(NotesDataDetails notesData) {
        return (DataDetails)DataDetails.builder().notesData(notesData).build();
    }

    public static DataDetails fromNotesData(Consumer<NotesDataDetails.Builder> notesData) {
        NotesDataDetails.Builder builder = NotesDataDetails.builder();
        notesData.accept(builder);
        return DataDetails.fromNotesData((NotesDataDetails)builder.build());
    }

    public static DataDetails fromNotesChunkData(NotesChunkDataDetails notesChunkData) {
        return (DataDetails)DataDetails.builder().notesChunkData(notesChunkData).build();
    }

    public static DataDetails fromNotesChunkData(Consumer<NotesChunkDataDetails.Builder> notesChunkData) {
        NotesChunkDataDetails.Builder builder = NotesChunkDataDetails.builder();
        notesChunkData.accept(builder);
        return DataDetails.fromNotesChunkData((NotesChunkDataDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentData", CONTENT_DATA_FIELD);
        map.put("generativeData", GENERATIVE_DATA_FIELD);
        map.put("intentDetectedData", INTENT_DETECTED_DATA_FIELD);
        map.put("sourceContentData", SOURCE_CONTENT_DATA_FIELD);
        map.put("generativeChunkData", GENERATIVE_CHUNK_DATA_FIELD);
        map.put("emailResponseChunkData", EMAIL_RESPONSE_CHUNK_DATA_FIELD);
        map.put("emailOverviewChunkData", EMAIL_OVERVIEW_CHUNK_DATA_FIELD);
        map.put("emailGenerativeAnswerChunkData", EMAIL_GENERATIVE_ANSWER_CHUNK_DATA_FIELD);
        map.put("caseSummarizationChunkData", CASE_SUMMARIZATION_CHUNK_DATA_FIELD);
        map.put("suggestedMessageData", SUGGESTED_MESSAGE_DATA_FIELD);
        map.put("notesData", NOTES_DATA_FIELD);
        map.put("notesChunkData", NOTES_CHUNK_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataDetails, T> g) {
        return obj -> g.apply((DataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTENT_DATA,
        GENERATIVE_DATA,
        INTENT_DETECTED_DATA,
        SOURCE_CONTENT_DATA,
        GENERATIVE_CHUNK_DATA,
        EMAIL_RESPONSE_CHUNK_DATA,
        EMAIL_OVERVIEW_CHUNK_DATA,
        EMAIL_GENERATIVE_ANSWER_CHUNK_DATA,
        CASE_SUMMARIZATION_CHUNK_DATA,
        SUGGESTED_MESSAGE_DATA,
        NOTES_DATA,
        NOTES_CHUNK_DATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ContentDataDetails contentData;
        private GenerativeDataDetails generativeData;
        private IntentDetectedDataDetails intentDetectedData;
        private SourceContentDataDetails sourceContentData;
        private GenerativeChunkDataDetails generativeChunkData;
        private EmailResponseChunkDataDetails emailResponseChunkData;
        private EmailOverviewChunkDataDetails emailOverviewChunkData;
        private EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData;
        private CaseSummarizationChunkDataDetails caseSummarizationChunkData;
        private SuggestedMessageDataDetails suggestedMessageData;
        private NotesDataDetails notesData;
        private NotesChunkDataDetails notesChunkData;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataDetails model) {
            this.contentData(model.contentData);
            this.generativeData(model.generativeData);
            this.intentDetectedData(model.intentDetectedData);
            this.sourceContentData(model.sourceContentData);
            this.generativeChunkData(model.generativeChunkData);
            this.emailResponseChunkData(model.emailResponseChunkData);
            this.emailOverviewChunkData(model.emailOverviewChunkData);
            this.emailGenerativeAnswerChunkData(model.emailGenerativeAnswerChunkData);
            this.caseSummarizationChunkData(model.caseSummarizationChunkData);
            this.suggestedMessageData(model.suggestedMessageData);
            this.notesData(model.notesData);
            this.notesChunkData(model.notesChunkData);
        }

        public final ContentDataDetails.Builder getContentData() {
            return this.contentData != null ? this.contentData.toBuilder() : null;
        }

        public final void setContentData(ContentDataDetails.BuilderImpl contentData) {
            ContentDataDetails oldValue = this.contentData;
            this.contentData = contentData != null ? contentData.build() : null;
            this.handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
        }

        @Override
        public final Builder contentData(ContentDataDetails contentData) {
            ContentDataDetails oldValue = this.contentData;
            this.contentData = contentData;
            this.handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
            return this;
        }

        public final GenerativeDataDetails.Builder getGenerativeData() {
            return this.generativeData != null ? this.generativeData.toBuilder() : null;
        }

        public final void setGenerativeData(GenerativeDataDetails.BuilderImpl generativeData) {
            GenerativeDataDetails oldValue = this.generativeData;
            this.generativeData = generativeData != null ? generativeData.build() : null;
            this.handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
        }

        @Override
        public final Builder generativeData(GenerativeDataDetails generativeData) {
            GenerativeDataDetails oldValue = this.generativeData;
            this.generativeData = generativeData;
            this.handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
            return this;
        }

        public final IntentDetectedDataDetails.Builder getIntentDetectedData() {
            return this.intentDetectedData != null ? this.intentDetectedData.toBuilder() : null;
        }

        public final void setIntentDetectedData(IntentDetectedDataDetails.BuilderImpl intentDetectedData) {
            IntentDetectedDataDetails oldValue = this.intentDetectedData;
            this.intentDetectedData = intentDetectedData != null ? intentDetectedData.build() : null;
            this.handleUnionValueChange(Type.INTENT_DETECTED_DATA, oldValue, this.intentDetectedData);
        }

        @Override
        public final Builder intentDetectedData(IntentDetectedDataDetails intentDetectedData) {
            IntentDetectedDataDetails oldValue = this.intentDetectedData;
            this.intentDetectedData = intentDetectedData;
            this.handleUnionValueChange(Type.INTENT_DETECTED_DATA, oldValue, this.intentDetectedData);
            return this;
        }

        public final SourceContentDataDetails.Builder getSourceContentData() {
            return this.sourceContentData != null ? this.sourceContentData.toBuilder() : null;
        }

        public final void setSourceContentData(SourceContentDataDetails.BuilderImpl sourceContentData) {
            SourceContentDataDetails oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData != null ? sourceContentData.build() : null;
            this.handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
        }

        @Override
        public final Builder sourceContentData(SourceContentDataDetails sourceContentData) {
            SourceContentDataDetails oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData;
            this.handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
            return this;
        }

        public final GenerativeChunkDataDetails.Builder getGenerativeChunkData() {
            return this.generativeChunkData != null ? this.generativeChunkData.toBuilder() : null;
        }

        public final void setGenerativeChunkData(GenerativeChunkDataDetails.BuilderImpl generativeChunkData) {
            GenerativeChunkDataDetails oldValue = this.generativeChunkData;
            this.generativeChunkData = generativeChunkData != null ? generativeChunkData.build() : null;
            this.handleUnionValueChange(Type.GENERATIVE_CHUNK_DATA, oldValue, this.generativeChunkData);
        }

        @Override
        public final Builder generativeChunkData(GenerativeChunkDataDetails generativeChunkData) {
            GenerativeChunkDataDetails oldValue = this.generativeChunkData;
            this.generativeChunkData = generativeChunkData;
            this.handleUnionValueChange(Type.GENERATIVE_CHUNK_DATA, oldValue, this.generativeChunkData);
            return this;
        }

        public final EmailResponseChunkDataDetails.Builder getEmailResponseChunkData() {
            return this.emailResponseChunkData != null ? this.emailResponseChunkData.toBuilder() : null;
        }

        public final void setEmailResponseChunkData(EmailResponseChunkDataDetails.BuilderImpl emailResponseChunkData) {
            EmailResponseChunkDataDetails oldValue = this.emailResponseChunkData;
            this.emailResponseChunkData = emailResponseChunkData != null ? emailResponseChunkData.build() : null;
            this.handleUnionValueChange(Type.EMAIL_RESPONSE_CHUNK_DATA, oldValue, this.emailResponseChunkData);
        }

        @Override
        public final Builder emailResponseChunkData(EmailResponseChunkDataDetails emailResponseChunkData) {
            EmailResponseChunkDataDetails oldValue = this.emailResponseChunkData;
            this.emailResponseChunkData = emailResponseChunkData;
            this.handleUnionValueChange(Type.EMAIL_RESPONSE_CHUNK_DATA, oldValue, this.emailResponseChunkData);
            return this;
        }

        public final EmailOverviewChunkDataDetails.Builder getEmailOverviewChunkData() {
            return this.emailOverviewChunkData != null ? this.emailOverviewChunkData.toBuilder() : null;
        }

        public final void setEmailOverviewChunkData(EmailOverviewChunkDataDetails.BuilderImpl emailOverviewChunkData) {
            EmailOverviewChunkDataDetails oldValue = this.emailOverviewChunkData;
            this.emailOverviewChunkData = emailOverviewChunkData != null ? emailOverviewChunkData.build() : null;
            this.handleUnionValueChange(Type.EMAIL_OVERVIEW_CHUNK_DATA, oldValue, this.emailOverviewChunkData);
        }

        @Override
        public final Builder emailOverviewChunkData(EmailOverviewChunkDataDetails emailOverviewChunkData) {
            EmailOverviewChunkDataDetails oldValue = this.emailOverviewChunkData;
            this.emailOverviewChunkData = emailOverviewChunkData;
            this.handleUnionValueChange(Type.EMAIL_OVERVIEW_CHUNK_DATA, oldValue, this.emailOverviewChunkData);
            return this;
        }

        public final EmailGenerativeAnswerChunkDataDetails.Builder getEmailGenerativeAnswerChunkData() {
            return this.emailGenerativeAnswerChunkData != null ? this.emailGenerativeAnswerChunkData.toBuilder() : null;
        }

        public final void setEmailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails.BuilderImpl emailGenerativeAnswerChunkData) {
            EmailGenerativeAnswerChunkDataDetails oldValue = this.emailGenerativeAnswerChunkData;
            this.emailGenerativeAnswerChunkData = emailGenerativeAnswerChunkData != null ? emailGenerativeAnswerChunkData.build() : null;
            this.handleUnionValueChange(Type.EMAIL_GENERATIVE_ANSWER_CHUNK_DATA, oldValue, this.emailGenerativeAnswerChunkData);
        }

        @Override
        public final Builder emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData) {
            EmailGenerativeAnswerChunkDataDetails oldValue = this.emailGenerativeAnswerChunkData;
            this.emailGenerativeAnswerChunkData = emailGenerativeAnswerChunkData;
            this.handleUnionValueChange(Type.EMAIL_GENERATIVE_ANSWER_CHUNK_DATA, oldValue, this.emailGenerativeAnswerChunkData);
            return this;
        }

        public final CaseSummarizationChunkDataDetails.Builder getCaseSummarizationChunkData() {
            return this.caseSummarizationChunkData != null ? this.caseSummarizationChunkData.toBuilder() : null;
        }

        public final void setCaseSummarizationChunkData(CaseSummarizationChunkDataDetails.BuilderImpl caseSummarizationChunkData) {
            CaseSummarizationChunkDataDetails oldValue = this.caseSummarizationChunkData;
            this.caseSummarizationChunkData = caseSummarizationChunkData != null ? caseSummarizationChunkData.build() : null;
            this.handleUnionValueChange(Type.CASE_SUMMARIZATION_CHUNK_DATA, oldValue, this.caseSummarizationChunkData);
        }

        @Override
        public final Builder caseSummarizationChunkData(CaseSummarizationChunkDataDetails caseSummarizationChunkData) {
            CaseSummarizationChunkDataDetails oldValue = this.caseSummarizationChunkData;
            this.caseSummarizationChunkData = caseSummarizationChunkData;
            this.handleUnionValueChange(Type.CASE_SUMMARIZATION_CHUNK_DATA, oldValue, this.caseSummarizationChunkData);
            return this;
        }

        public final SuggestedMessageDataDetails.Builder getSuggestedMessageData() {
            return this.suggestedMessageData != null ? this.suggestedMessageData.toBuilder() : null;
        }

        public final void setSuggestedMessageData(SuggestedMessageDataDetails.BuilderImpl suggestedMessageData) {
            SuggestedMessageDataDetails oldValue = this.suggestedMessageData;
            this.suggestedMessageData = suggestedMessageData != null ? suggestedMessageData.build() : null;
            this.handleUnionValueChange(Type.SUGGESTED_MESSAGE_DATA, oldValue, this.suggestedMessageData);
        }

        @Override
        public final Builder suggestedMessageData(SuggestedMessageDataDetails suggestedMessageData) {
            SuggestedMessageDataDetails oldValue = this.suggestedMessageData;
            this.suggestedMessageData = suggestedMessageData;
            this.handleUnionValueChange(Type.SUGGESTED_MESSAGE_DATA, oldValue, this.suggestedMessageData);
            return this;
        }

        public final NotesDataDetails.Builder getNotesData() {
            return this.notesData != null ? this.notesData.toBuilder() : null;
        }

        public final void setNotesData(NotesDataDetails.BuilderImpl notesData) {
            NotesDataDetails oldValue = this.notesData;
            this.notesData = notesData != null ? notesData.build() : null;
            this.handleUnionValueChange(Type.NOTES_DATA, oldValue, this.notesData);
        }

        @Override
        public final Builder notesData(NotesDataDetails notesData) {
            NotesDataDetails oldValue = this.notesData;
            this.notesData = notesData;
            this.handleUnionValueChange(Type.NOTES_DATA, oldValue, this.notesData);
            return this;
        }

        public final NotesChunkDataDetails.Builder getNotesChunkData() {
            return this.notesChunkData != null ? this.notesChunkData.toBuilder() : null;
        }

        public final void setNotesChunkData(NotesChunkDataDetails.BuilderImpl notesChunkData) {
            NotesChunkDataDetails oldValue = this.notesChunkData;
            this.notesChunkData = notesChunkData != null ? notesChunkData.build() : null;
            this.handleUnionValueChange(Type.NOTES_CHUNK_DATA, oldValue, this.notesChunkData);
        }

        @Override
        public final Builder notesChunkData(NotesChunkDataDetails notesChunkData) {
            NotesChunkDataDetails oldValue = this.notesChunkData;
            this.notesChunkData = notesChunkData;
            this.handleUnionValueChange(Type.NOTES_CHUNK_DATA, oldValue, this.notesChunkData);
            return this;
        }

        public DataDetails build() {
            return new DataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataDetails> {
        public Builder contentData(ContentDataDetails var1);

        default public Builder contentData(Consumer<ContentDataDetails.Builder> contentData) {
            return this.contentData((ContentDataDetails)((ContentDataDetails.Builder)ContentDataDetails.builder().applyMutation(contentData)).build());
        }

        public Builder generativeData(GenerativeDataDetails var1);

        default public Builder generativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
            return this.generativeData((GenerativeDataDetails)((GenerativeDataDetails.Builder)GenerativeDataDetails.builder().applyMutation(generativeData)).build());
        }

        public Builder intentDetectedData(IntentDetectedDataDetails var1);

        default public Builder intentDetectedData(Consumer<IntentDetectedDataDetails.Builder> intentDetectedData) {
            return this.intentDetectedData((IntentDetectedDataDetails)((IntentDetectedDataDetails.Builder)IntentDetectedDataDetails.builder().applyMutation(intentDetectedData)).build());
        }

        public Builder sourceContentData(SourceContentDataDetails var1);

        default public Builder sourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
            return this.sourceContentData((SourceContentDataDetails)((SourceContentDataDetails.Builder)SourceContentDataDetails.builder().applyMutation(sourceContentData)).build());
        }

        public Builder generativeChunkData(GenerativeChunkDataDetails var1);

        default public Builder generativeChunkData(Consumer<GenerativeChunkDataDetails.Builder> generativeChunkData) {
            return this.generativeChunkData((GenerativeChunkDataDetails)((GenerativeChunkDataDetails.Builder)GenerativeChunkDataDetails.builder().applyMutation(generativeChunkData)).build());
        }

        public Builder emailResponseChunkData(EmailResponseChunkDataDetails var1);

        default public Builder emailResponseChunkData(Consumer<EmailResponseChunkDataDetails.Builder> emailResponseChunkData) {
            return this.emailResponseChunkData((EmailResponseChunkDataDetails)((EmailResponseChunkDataDetails.Builder)EmailResponseChunkDataDetails.builder().applyMutation(emailResponseChunkData)).build());
        }

        public Builder emailOverviewChunkData(EmailOverviewChunkDataDetails var1);

        default public Builder emailOverviewChunkData(Consumer<EmailOverviewChunkDataDetails.Builder> emailOverviewChunkData) {
            return this.emailOverviewChunkData((EmailOverviewChunkDataDetails)((EmailOverviewChunkDataDetails.Builder)EmailOverviewChunkDataDetails.builder().applyMutation(emailOverviewChunkData)).build());
        }

        public Builder emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails var1);

        default public Builder emailGenerativeAnswerChunkData(Consumer<EmailGenerativeAnswerChunkDataDetails.Builder> emailGenerativeAnswerChunkData) {
            return this.emailGenerativeAnswerChunkData((EmailGenerativeAnswerChunkDataDetails)((EmailGenerativeAnswerChunkDataDetails.Builder)EmailGenerativeAnswerChunkDataDetails.builder().applyMutation(emailGenerativeAnswerChunkData)).build());
        }

        public Builder caseSummarizationChunkData(CaseSummarizationChunkDataDetails var1);

        default public Builder caseSummarizationChunkData(Consumer<CaseSummarizationChunkDataDetails.Builder> caseSummarizationChunkData) {
            return this.caseSummarizationChunkData((CaseSummarizationChunkDataDetails)((CaseSummarizationChunkDataDetails.Builder)CaseSummarizationChunkDataDetails.builder().applyMutation(caseSummarizationChunkData)).build());
        }

        public Builder suggestedMessageData(SuggestedMessageDataDetails var1);

        default public Builder suggestedMessageData(Consumer<SuggestedMessageDataDetails.Builder> suggestedMessageData) {
            return this.suggestedMessageData((SuggestedMessageDataDetails)((SuggestedMessageDataDetails.Builder)SuggestedMessageDataDetails.builder().applyMutation(suggestedMessageData)).build());
        }

        public Builder notesData(NotesDataDetails var1);

        default public Builder notesData(Consumer<NotesDataDetails.Builder> notesData) {
            return this.notesData((NotesDataDetails)((NotesDataDetails.Builder)NotesDataDetails.builder().applyMutation(notesData)).build());
        }

        public Builder notesChunkData(NotesChunkDataDetails var1);

        default public Builder notesChunkData(Consumer<NotesChunkDataDetails.Builder> notesChunkData) {
            return this.notesChunkData((NotesChunkDataDetails)((NotesChunkDataDetails.Builder)NotesChunkDataDetails.builder().applyMutation(notesChunkData)).build());
        }
    }
}

