/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListMessagesRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessagesResponse;
import software.amazon.awssdk.services.qconnect.model.MessageOutput;

public class ListMessagesIterable
implements SdkIterable<ListMessagesResponse> {
    private final QConnectClient client;
    private final ListMessagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMessagesIterable(QConnectClient client, ListMessagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMessagesResponseFetcher();
    }

    public Iterator<ListMessagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MessageOutput> messages() {
        Function<ListMessagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.messages() != null) {
                return response.messages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMessagesResponseFetcher
    implements SyncPageFetcher<ListMessagesResponse> {
        private ListMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMessagesResponse nextPage(ListMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListMessagesIterable.this.client.listMessages(ListMessagesIterable.this.firstRequest);
            }
            return ListMessagesIterable.this.client.listMessages((ListMessagesRequest)((Object)ListMessagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

