/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.SpanMessageValue;
import software.amazon.awssdk.services.qconnect.model.SpanMessageValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpanToolResultValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpanToolResultValue> {
    private static final SdkField<String> TOOL_USE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolUseId").getter(SpanToolResultValue.getter(SpanToolResultValue::toolUseId)).setter(SpanToolResultValue.setter(Builder::toolUseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUseId").build()}).build();
    private static final SdkField<List<SpanMessageValue>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(SpanToolResultValue.getter(SpanToolResultValue::values)).setter(SpanToolResultValue.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpanMessageValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(SpanToolResultValue.getter(SpanToolResultValue::error)).setter(SpanToolResultValue.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_USE_ID_FIELD, VALUES_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpanToolResultValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String toolUseId;
    private final List<SpanMessageValue> values;
    private final String error;

    private SpanToolResultValue(BuilderImpl builder) {
        this.toolUseId = builder.toolUseId;
        this.values = builder.values;
        this.error = builder.error;
    }

    public final String toolUseId() {
        return this.toolUseId;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<SpanMessageValue> values() {
        return this.values;
    }

    public final String error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanToolResultValue)) {
            return false;
        }
        SpanToolResultValue other = (SpanToolResultValue)obj;
        return Objects.equals(this.toolUseId(), other.toolUseId()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"SpanToolResultValue").add("ToolUseId", (Object)this.toolUseId()).add("Values", this.hasValues() ? this.values() : null).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "toolUseId": {
                return Optional.ofNullable(clazz.cast(this.toolUseId()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("toolUseId", TOOL_USE_ID_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanToolResultValue, T> g) {
        return obj -> g.apply((SpanToolResultValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String toolUseId;
        private List<SpanMessageValue> values = DefaultSdkAutoConstructList.getInstance();
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(SpanToolResultValue model) {
            this.toolUseId(model.toolUseId);
            this.values(model.values);
            this.error(model.error);
        }

        public final String getToolUseId() {
            return this.toolUseId;
        }

        public final void setToolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
        }

        @Override
        public final Builder toolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
            return this;
        }

        public final List<SpanMessageValue.Builder> getValues() {
            List<SpanMessageValue.Builder> result = SpanMessageValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<SpanMessageValue.BuilderImpl> values) {
            this.values = SpanMessageValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<SpanMessageValue> values) {
            this.values = SpanMessageValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(SpanMessageValue ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<SpanMessageValue.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (SpanMessageValue)((SpanMessageValue.Builder)SpanMessageValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public SpanToolResultValue build() {
            return new SpanToolResultValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpanToolResultValue> {
        public Builder toolUseId(String var1);

        public Builder values(Collection<SpanMessageValue> var1);

        public Builder values(SpanMessageValue ... var1);

        public Builder values(Consumer<SpanMessageValue.Builder> ... var1);

        public Builder error(String var1);
    }
}

